[CmdletBinding()]
Param(
    [Parameter(Mandatory=$True,Position=0)]
    [string]$AppPool,
    [Parameter(Mandatory=$True,Position=1)]
    )


# Sanity Checks
try {
    Get-WebAppPoolState -Name $AppPool
    Get-Website -Name $AppPool
} catch {
    Write-Host "AppPool or Website named $AppPool does not exist: $_"

    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,3030)
    $udpclient=new-Object System.Net.Sockets.UdpClient

    $checkJson = @{
        name = "$AppPool-Recycle"
        output = "$_"
        status = 1
    } | ConvertTo-Json

    $JsonBytes = [system.Text.Encoding]::UTF8.GetBytes($checkJson)

    $bytesSent=$udpclient.Send($JsonBytes,$JsonBytes.length,$endpoint)
    $udpclient.Close()
    exit 2
}


# Stop the HealthMonitor and waits for connections to drain
try {
    Stop-WebAppPool HealthMonitor
} catch {
    Write-Host "Could not stop HealthMonitor: $_"

    $endpoint = new-object System.Net.IPEndPoint ([IPAddress]::Loopback,3030)
    $udpclient=new-Object System.Net.Sockets.UdpClient

    $checkJson = @{
        name = "$AppPool-Recycle"
        output = "Could not stop HealthMonitor: $_"
        status = 1
    } | ConvertTo-Json

    $JsonBytes = [system.Text.Encoding]::UTF8.GetBytes($checkJson)

    $bytesSent=$udpclient.Send($JsonBytes,$JsonBytes.length,$endpoint)
    $udpclient.Close()
    exit 1
}


Start-Sleep 15 # ELB Timeout
Write-Host "HealthMonitor has been stopped" -ForegroundColor DarkYellow

#Gets active connections on IIS App Pools, runs in a while loop until they are less than 10
$conn = Get-Counter "\web service(_total)\current connections"
echo $conn.CounterSamples.CookedValue

$tries = 60 # Try for 60*5 seconds (5 minutes)
while ($conn.CounterSamples.CookedValue -gt 5) {
    Start-Sleep 5
    if ($tries-- -lt 1) {break}
    $conn = Get-Counter "\web service(_total)\current connections"
    echo $conn.CounterSamples.CookedValue
}


# Restart the main AppPool
Write-Host "Restarting app pool $AppPool"
Restart-WebAppPool $AppPool
start-sleep 25


# Send a request to warm the pool
try {
    $WebHost = (Get-Website -Name $AppPool | Get-WebBinding | Select-Object -first 1).bindingInformation.Split(":")[2]
    $request = [System.Net.HttpWebRequest]::Create('http://localhost/')
    $request.Host = $WebHost
    $request.Timeout = 60
    $response = $request.GetResponse()
    $response.Close()
} catch {
    Write-Host "Error connecting to localhost: $_"
    start-sleep 30
}


# Start the Health Monitor
Write-Host "Starting HealthMonitor"
try {
    Start-WebAppPool HealthMonitor
} catch {
    start-sleep 5
    Start-WebAppPool HealthMonitor
}

