# frozen_string_literal: true

# Cookbook:: app_influxdb
# Recipe:: data
#
# Copyright:: 2017, Curse, All Rights Reserved.
set_role_tag
node.override['influxdb']['data']['config']['hostname'] = node['hostname']

include_recipe 'base_server_ubuntu'
include_recipe "#{cookbook_name}::hosts"

filesystem 'influxdb_data' do
  device node['influxdb']['mounts']['data']
  fstype 'ext4'
  mount '/mnt/influxdb_data'
  action [:create, :enable, :mount]
end

filesystem 'influxdb_wal' do
  device node['influxdb']['mounts']['wal']
  fstype 'ext4'
  mount '/mnt/influxdb_wal'
  action [:create, :enable, :mount]
end

include_recipe 'sds_influxdb::data'

influxdb_database 'demeter' do
  auth_username 'cpe'
  auth_password arcana_read('influxdb_cpe_password')
  action :create
end

influxdb_admin 'cpe' do
  auth_username 'cpe'
  auth_password arcana_read('influxdb_cpe_password')
  password arcana_read('influxdb_cpe_password')
  action [:create, :update]
end

influxdb_user 'demeter' do
  auth_username 'cpe'
  auth_password arcana_read('influxdb_cpe_password')
  password arcana_read('influxdb_demeter_password')
  databases ['demeter']
  action [:create, :update]
end

influxdb_retention_policy 'raw_statistics' do
  auth_username 'cpe'
  auth_password arcana_read('influxdb_cpe_password')
  policy_name 'raw_statistics'
  database 'demeter'
  duration '36h'
  replication 2
  action :create
end

node.override['influxdb']['monitoring']['functional']['fail_empty'] = true
node.override['influxdb']['monitoring']['functional']['database'] = 'demeter_complete_transition'
node.override['influxdb']['monitoring']['functional']['query'] = %w(SELECT percentile("duration", 90)
  FROM complete_transition WHERE "is_app_launch" = 'true' AND "lost_visibility" = 'false'
  AND "domain" =~ /twitch.tv$/ AND time > now() - 10m).join(' ')
include_recipe '::data_monitoring'
