execute 'reload-external-yum-cache' do
    command 'yum makecache'
    action :nothing
end

ruby_block "reload-internal-yum-cache" do
    block do
        Chef::Provider::Package::Yum::YumCache.instance.reload
    end
    action :nothing
end

execute "enable epel" do
    command "amazon-linux-extras enable epel"
    notifies :run, resources(:execute => 'reload-external-yum-cache'), :immediately
    notifies :create, resources(:ruby_block => 'reload-internal-yum-cache'), :immediately
    not_if "amazon-linux-extras list | grep epel | grep -q enabled"
end

package "epel-release"

package "awscli" do
    version '1.16.300-1.amzn2.0.1'
end
package "git-all"
package "git-lfs"

execute 'git-enable-lfs' do
    command '/usr/bin/git lfs install --system'
end

include_recipe 'sds_teamcity::agent'

directory '/opt/jetbrains/TeamCity/.ssh' do
  owner 'teamcity'
  group 'teamcity'
  mode 0700
end

file '/opt/jetbrains/TeamCity/.ssh/twitch-ghe-read-key' do
  content arcana_read('twitch-ghe-read-key')
  owner 'teamcity'
  group 'teamcity'
  mode 0600
  sensitive true
end

file "/opt/jetbrains/TeamCity/.ssh/csi-svc-github.com" do
  content arcana_read('csi-svc-github.com')
  owner 'teamcity'
  group 'teamcity'
  mode 0600
  sensitive true
end

file '/opt/jetbrains/TeamCity/.ssh/config' do
  content <<-EOF
Host git-aws.internal.justin.tv
  StrictHostKeyChecking no
  UserKnownHostsFile=/dev/null
  HostName git-aws.internal.justin.tv
  IdentityFile ~/.ssh/twitch-ghe-read-key

Host git.xarth.tv
  StrictHostKeyChecking no
  UserKnownHostsFile=/dev/null
  HostName git.xarth.tv
  IdentityFile ~/.ssh/twitch-ghe-read-key

Host github.com
  StrictHostKeyChecking no
  UserKnownHostsFile /dev/null
  HostName github.com
  IdentityFile ~/.ssh/csi-svc-github.com
  EOF
  owner 'teamcity'
  group 'teamcity'
  mode 0600
end

cron 'teamcity-cleanup' do
  command '/usr/bin/find /opt/jetbrains/TeamCity_agent/work/.old  -maxdepth 1 -mtime +2 -exec rm -rf "{}" +'
  hour '2'
end

cron 'fix-root-files' do
  command '/usr/bin/find /opt/jetbrains/TeamCity_agent/work -not -user teamcity -exec chown teamcity:teamcity "{}" \;'
end

cron 'fix-root-files-faster' do
  command 'sleep 30; /usr/bin/find /opt/jetbrains/TeamCity_agent/work -not -user teamcity -exec chown teamcity:teamcity "{}" \;'
end

# directory '/etc/systemd/system/sensu-client.service.d' do
#   recursive true
#   action node['sensu']['systemd']['niceness'] != 0 ? :create : :delete
# end

# template '/etc/systemd/system/sensu-client.service.d/override.conf' do
#   source 'sensu-client.service.override.conf.erb'
#   mode 00644
#   helper(:sensu) { node['sensu'] }
#   notifies :run, 'execute[systemctl daemon-reload]', :immediately
#   notifies :restart, 'sensu_service[sensu-client]', :delayed
#   action node['sensu']['systemd']['niceness'] != 0 || node['sensu']['systemd']['oom_score_adjust'] != 0 ? :create : :delete
# end
