node.default['teamcity']['agent']['env_properties']['DOCKER_AGENT'] = 1
node.default['teamcity']['agent']['env_properties']['DOCKER_HOST'] = 'unix:///var/run/docker.sock'

docker_service 'default' do
  install_method 'package'
  version '19.03.8'
  dns ['169.254.169.253']
  host ['unix:///var/run/docker.sock', 'tcp://0.0.0.0:2376']
  systemd_opts ['TasksMax=infinity', 'MountFlags=private']
  action [:create, :start]
end

# TODO: we should mirror this locally
remote_file '/usr/local/bin/docker-compose' do
  source 'https://github.com/docker/compose/releases/download/1.23.2/docker-compose-Linux-x86_64'
  owner 'root'
  group 'root'
  mode '0755'
  action :create
end

cookbook_file '/usr/local/bin/docker-clean' do
  source 'docker-clean'
  mode '0755'
end

cookbook_file '/usr/local/bin/docker-system-prune' do
  source 'docker-system-prune'
  mode '0755'
end

cookbook_file '/usr/local/bin/ecr_auth.sh' do
  source 'ecr_auth.sh'
  mode '0755'
end

cookbook_file '/usr/local/bin/ecr_push.sh' do
  source 'ecr_push.sh'
  mode '0755'
end

cron 'docker-clean' do
  command '/usr/local/bin/docker-clean > /dev/null 2>&1'
  minute '0'
  path '/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin'
end

cron 'docker-system-prune' do
  command '/usr/local/bin/docker-system-prune > /dev/null 2>&1'
  hour '0'
  minute '0'
  path '/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin'
end
