override['chef_client']['config']['ssl_ca_file'] = '/etc/chef/opsworks-cm-ca-root.pem' unless ENV['TEST_KITCHEN']

override['chef_client']['interval'] = 300
override['chef_client']['splay'] = 240
override['chef_client']['config']['ssl_verify_mode'] = 'verify_none'
override['chef_client']['config']['verify_api_cert'] = false
override['chef_client']['config']['client_fork'] = true

default['ntp']['package_url'] = 'https://s3.amazonaws.com/cursecomms/WindowsPackages/ntp-4.2.8p5-win32-setup.exe'
default['ntp']['vs_runtime_url'] = 'https://s3.amazonaws.com/cursecomms/WindowsPackages/vcredist_x86_2008.exe'

default["sensu"]["msi_repo_url"] = "https://gen.pkgs.xarth.tv/artifactory/ip-windows/x64"
default["sensu"]["version"] = "1.7.0-1"
default['sensu']['use_ssl'] = false

default['sensu']['transport']['name'] = 'snssqs'
default['sensu']['transport']['reconnect_on_error'] = true

default['sensu']['common_config']['snssqs']['publishing_sns_topic_arn'] = "arn:aws:sns:#{get_region}:#{get_aws_account}:sensu_ingress"
default['sensu']['common_config']['snssqs']['region'] = get_region

default['sensu']['client_options'] = Mash.new
default['sensu']['client_options']['keepalive']['thresholds']['warning'] = 150
default['sensu']['client_options']['keepalive']['thresholds']['critical'] = 300
default['sensu']['client_options']['keepalive']['handler'] = 'pagerduty'
default['sensu']['client_options']['public_hostname'] = node['cloud']['public_hostname']
default['sensu']['client_options']['instance_id'] = node['ec2']['instance_id']

default['sensu']['client_options']['os'] = node['os']
default['sensu']['client_options']['os_version'] = node['os_version']
default['sensu']['client_options']['platform'] = node['platform']
default['sensu']['client_options']['platform_version'] = node['platform_version']
default['sensu']['client_options']['platform_family'] = node['platform_family']

default['windows_dns']['forwarder'] = nil
