default_action :create

property :user_name, :kind_of => String, :name_attribute => true
property :group_name, :kind_of => String
property :home, :kind_of => String
property :shell, :kind_of => String, :equal_to => %w(/bin/bash /bin/zsh /usr/bin/zsh /usr/sbin/nologin), :default => '/usr/bin/zsh'
property :uid, :kind_of => Integer, :required => true
property :gid, :kind_of => Integer
property :admin, :kind_of => [TrueClass, FalseClass], :default => false
property :ssh_key, :kind_of => String
property :ssh_key_type, :kind_of => String
property :password, :kind_of => String
property :admin_group, :kind_of => String, :default => node[:platform_family].eql?('debian') ? 'sudo' : 'wheel'


action :create do

  package 'zsh'
  package 'passwd'

  home_dir = new_resource.home ? new_resource.home : "/home/#{new_resource.user_name}"
  group_name = new_resource.group_name || new_resource.user_name

  if new_resource.shell.eql?('/usr/bin/zsh') && !node['platform_family'].eql?('debian')
    new_resource.shell = '/bin/zsh'
  end

  group group_name do
    gid new_resource.gid || new_resource.uid
    not_if "grep -q '^#{group_name}:' /etc/group"
  end

  user new_resource.user_name do
    uid new_resource.uid
    gid new_resource.gid || new_resource.uid
    manage_home true
    home home_dir
    shell new_resource.shell
    password new_resource.password || ''
    notifies :run, "execute[del-#{new_resource.user_name}-pw]", :immediately
  end

  cookbook_file "#{home_dir}/.zshrc" do
    source 'zshrc'
    cookbook 'lib_cpe'
    owner new_resource.user_name
    group group_name
    mode '0755'
    only_if { new_resource.shell.eql?('/usr/bin/zsh')}
  end

  if new_resource.ssh_key

    directory "#{home_dir}/.ssh" do
      owner new_resource.user_name
      group new_resource.gid || new_resource.user_name
      mode '0700'
    end

    ssh_key_type = "ssh-#{new_resource.ssh_key_type}"

    file "#{home_dir}/.ssh/authorized_keys2" do
      content "#{ssh_key_type} #{new_resource.ssh_key} #{new_resource.user_name}\n"
      owner new_resource.user_name
      group new_resource.gid || new_resource.user_name
      mode '0600'
    end

  end

  if new_resource.admin
    execute "add-admin-#{new_resource.user_name}" do
      command "/usr/sbin/usermod -a -G #{new_resource.admin_group} #{new_resource.user_name}"
      guard_interpreter :bash
      not_if "/usr/bin/groups #{new_resource.user_name} | grep -q '\\b#{new_resource.admin_group}\\b'"
    end
  else
    execute "del-admin-#{new_resource.user_name}" do
      command "/usr/bin/gpasswd -d #{new_resource.user_name} #{new_resource.admin_group}"
      guard_interpreter :bash
      only_if "/usr/bin/groups #{new_resource.user_name} | grep -q '\\b#{new_resource.admin_group}\\b'"
    end
  end

  execute "del-#{new_resource.user_name}-pw" do
    command "/usr/bin/passwd -d #{new_resource.user_name}"
    action :nothing
  end

end

action :delete do

  package 'passwd'

  home_dir = "/home/#{new_resource.user_name}"

  execute "del-admin-#{new_resource.user_name}" do
    command "/usr/bin/gpasswd -d #{new_resource.user_name} #{new_resource.admin_group}"
    guard_interpreter :bash
    only_if "/usr/bin/groups #{new_resource.user_name} | grep -q '\\b#{new_resource.admin_group}\\b'"
  end

  file "#{home_dir}/.ssh/authorized_keys2" do
    action :delete
  end

  user new_resource.user_name do
    action :remove
  end

  group new_resource.user_name do
    action :remove
  end

end
