#
# Cookbook:: lib_cpe_test
# Recipe:: default
#
# Copyright:: 2017, The Authors, All Rights Reserved.

## Create a user
unless platform?('windows')
  lib_cpe_user 'cheftest' do
    uid 5001
    ssh_key 'GIBBERISH'
    ssh_key_type 'rsa'
    admin true
  end

  ## Create and delete a user
  lib_cpe_user 'cheftest2' do
    uid 5002
    ssh_key 'GIBBERISH'
    ssh_key_type 'rsa'
    admin true
  end

  lib_cpe_user 'cheftest2' do
    uid 5002
    ssh_key 'GIBBERISH'
    ssh_key_type 'rsa'
    admin true
    action :delete
  end

  lib_cpe_user 'cheftest_ssh_ed25519' do
    uid 5003
    ssh_key 'GIBBERISH'
    ssh_key_type 'ed25519'
    admin true
  end

end

directory '/tmp' if platform?('windows')

## Test Ohai EC2 Helpers in recipe context
ec2_metadata_recipe_test = {
    region: get_region,
    availability_zone: get_availability_zone,
    account: get_aws_account
}

file '/tmp/ec2_metadata_recipe_test.json' do
  content ec2_metadata_recipe_test.to_json
end

## Test Ohai EC2 Helpers in attribute context
file '/tmp/ec2_metadata_attribute_test.json' do
  content node['ec2_metadata_attribute_test'].to_json
end

set_role_tag

## Test Arcana Read
file '/tmp/arcana_secret.txt' do
  content arcana_read('test_kitchen_lib_cpe_secret')
end

# Test S3 Download
s3_file '/tmp/s3_file_test.txt' do
  bucket 'test-kitchen-infra-dev-us-west-1'
  key 's3_file_test.txt'
  owner 'root' unless platform?('windows')
  mode 0500 unless platform?('windows')
end

# Test S3 Local Delete action
s3_file '/tmp/s3_file_test_delete.txt' do
  bucket 'test-kitchen-infra-dev-us-west-1'
  key 's3_file_test.txt'
  owner 'root' unless platform?('windows')
  mode 0500 unless platform?('windows')
end

s3_file '/tmp/s3_file_test_delete.txt' do
  action :delete
end

s3_gem 'csi-test' do
  version '0.1.0'
  bucket 'test-kitchen-infra-dev-us-west-1'
  gem_binary Chef::Util::PathHelper.join(Chef::Config.embedded_dir,'bin','gem')
end
