# # encoding: utf-8

# Inspec test for recipe lib_cpe

# The Inspec reference, with examples and extensive documentation, can be
# found at http://inspec.io/docs/reference/resources/

unless os.windows?

  describe user('cheftest') do
    it { should exist }
    its('shell') { should be_in %w( /bin/zsh /usr/bin/zsh ) }
    its('home') { should eq '/home/cheftest' }
    its('uid') { should eq 5001 }
    its('gid') { should eq 5001 }
  end
  describe file('/home/cheftest/.ssh/authorized_keys2') do
    its('content') { should match(%r{ssh-rsa}) }
  end

  describe user('cheftest2') do
    it { should_not exist }
  end

  describe user('cheftest_ssh_ed25519') do
    it { should exist }
  end
  describe file('/home/cheftest_ssh_ed25519/.ssh/authorized_keys2') do
    its('content') { should match(%r{ssh-ed25519}) }
  end

end

describe json('/tmp/ec2_metadata_recipe_test.json') do
  its('region') { should eq 'us-west-1' }
  its('availability_zone') { should be_in %w(a b c) }
  its('account') { should eq '432112285195' }
end

describe json('/tmp/ec2_metadata_attribute_test.json') do
  its('region') { should eq 'us-west-1' }
  its('availability_zone') { should be_in %w(a b c)}
  its('account') { should eq '432112285195' }
end

describe file('/tmp/arcana_secret.txt') do
  its('content') { should match %r(^QWERTYUIOPasdfghjkl1234567890zxcvbnm,./(\r)*(\n)*$) }
end

unless os.windows?
  describe file('/tmp/s3_file_test.txt') do
    its('content') { should match %r(^I'm a little teapot, short and stout(\r)*(\n)*$) }
    it { should be_owned_by 'root' } 
    its('mode') { should cmp '0500' }
  end
else
  describe file('/tmp/s3_file_test.txt') do
    its('content') { should match %r(^I'm a little teapot, short and stout(\r)*(\n)*$) }
  end
end

describe file('/tmp/s3_file_test_delete.txt') do
  it { should_not exist}
end

unless os.windows?
  describe gem('csi-test', "/opt/chef/embedded/bin/gem") do
    it { should be_installed }
  end
else
  describe gem('csi-test', "/opscode/chef/embedded/bin/gem") do
    it { should be_installed }
  end
end
