
module SdsAptly
  module Helpers
    def env_execute
      {
          'HOME' => node['aptly']['root_dir'],
          'USER' => node['aptly']['user']
      }
    end

    def cmd_mirror_create(mirror)
      ['aptly mirror create',
       mirror.filters.count > 0 ? "-filter='#{mirror.filters.join(' | ')}'" : '',
       '-force-components',
       mirror.repo_name,
       mirror.uri,
       mirror.distribution,
       mirror.components.join(' '),
      ].select{ |part| part != '' }.join(' ')
    end

    def cmd_repo_create(repo)
      ['aptly repo create',
       repo.comment.length > 0 ? "-comment=\"#{repo.comment}\"" : '',
       "-distribution=\"#{repo.distribution}\"",
       "-component=\"#{repo.component}\"",
       repo.name,
      ].select{ |part| part != '' }.join(' ')
    end

    def cmd_repo_add(repo)
      ['aptly repo add',
       repo.repo_name,
       "/tmp/repos/#{repo.files}",
      ].select{ |part| part != '' }.join(' ')
    end

    def cmd_merge_create(merge, snapshots)
      ['aptly snapshot merge',
       merge.latest ? '-latest' : '-no-remove',
       "#{merge.name}-#{merge.timestamp}",
       snapshots.join(' '),
      ].select{ |part| part != '' }.join(' ')
    end

    def cmd_publish_snapshot(merge)
      ['aptly publish snapshot',
       "-distribution=#{merge.name}",
       "#{merge.name}-#{merge.timestamp}",
      ].select{ |part| part != '' }.join(' ')
    end
  end
end
