#
# Cookbook:: sds_aptly
# Recipe:: default
#
# Copyright:: 2017, Curse, All Rights Reserved.

apt_repository 'aptly' do
  uri 'http://repo.aptly.info'
  distribution 'squeeze'
  components ['main']
  keyserver 'keys.gnupg.net'
  key '2A194991'
  trusted true
end

package 'aptly' do
  version node['aptly']['version']
end

group node['aptly']['group']

user node['aptly']['user'] do
  shell '/bin/bash'
  system true
  manage_home true
  gid node['aptly']['group']
  home node['aptly']['root_dir']
end

template '/etc/aptly.conf' do
  source 'aptly.conf.erb'
  helper(:aptly) { node['aptly'] }
  owner 'root'
  group 'root'
  mode 00644
end

%w{db pool public}.each do |dir|
  directory "#{node['aptly']['root_dir']}/#{dir}" do
    owner node['aptly']['user']
    group node['aptly']['group']
    mode 00755
  end
end