require 'chef/mixin/shell_out'
include Chef::Mixin::ShellOut

actions :create
default_action :create

state_attrs :name, :interval

property :name, :kind_of => String, :name_attribute => true
property :interval, :kind_of => Fixnum, :required => true

action :create do

  cleanup_stamp = ::File.join(node['aptly']['root_dir'], ".#{new_resource.name}-cleanup-stamp")

  file cleanup_stamp do
    user node['aptly']['user']
    group node['aptly']['group']

    action :nothing
  end

  execute "aptly db #{new_resource.name} cleanup" do
    command 'aptly db cleanup'

    user node['aptly']['user']
    group node['aptly']['group']

    extend SdsAptly::Helpers
    environment env_execute

    not_if do
      ::File.exists?(cleanup_stamp) && ::File.mtime(cleanup_stamp) > Time.now - node['aptly']['periodic_cleanup_delay']
    end

    notifies :touch, "file[#{cleanup_stamp}]"
  end

end
