require 'chef/mixin/shell_out'
include Chef::Mixin::ShellOut

actions :create
default_action :create

state_attrs :name, :pattern, :timestamp, :latest

property :name, :kind_of => String, :name_attribute => true
property :timestamp, :kind_of => String, :default => Time.now.strftime('%Y-%m')
property :includes, :kind_of => String
property :excludes, :kind_of => String
property :latest, :kind_of => [TrueClass, FalseClass], :default => false

action :create do
  cmd = shell_out("aptly snapshot list -raw | grep #{new_resource.timestamp}$")
  cmd.run_command
  snapshots = cmd.stdout.split
  snapshots = snapshots.select { |snapshot| snapshot[/#{new_resource.includes}/] } if new_resource.includes
  snapshots = snapshots.reject { |snapshot| snapshot[/#{new_resource.excludes}/] } if new_resource.excludes

  execute "aptly merge create #{new_resource.name}" do
    extend SdsAptly::Helpers
    command cmd_merge_create(new_resource, snapshots)

    user node['aptly']['user']
    group node['aptly']['group']
    environment env_execute

    not_if do snapshots.count == 0 end
    not_if "aptly snapshot list -raw | grep ^#{new_resource.name}-#{new_resource.timestamp}$"
  end

  execute "aptly publish #{new_resource.name}" do
    extend SdsAptly::Helpers
    command cmd_publish_snapshot(new_resource)

    user node['aptly']['user']
    group node['aptly']['group']
    environment env_execute

    not_if "aptly publish list -raw | grep '^. #{new_resource.name}$'"
  end

end
