actions :create
default_action :create

property :repo_name, :kind_of => String, :name_attribute => true
property :distribution, :kind_of => String, :required => true
property :component, :kind_of => String, :required => true
property :comment, :kind_of => String, :required => true
property :files, :kind_of => String

action :create do

  execute "aptly repo create #{new_resource.repo_name}" do
    extend SdsAptly::Helpers
    command cmd_repo_create(new_resource)

    user node['aptly']['user']
    group node['aptly']['group']
    environment env_execute

    not_if "aptly repo -raw list | grep ^#{new_resource.repo_name}$"
  end

  unless new_resource.files.empty?
    execute "aptly repo add #{new_resource.repo_name}" do
      extend SdsAptly::Helpers
      command cmd_repo_add(new_resource)

      user node['aptly']['user']
      group node['aptly']['group']
      environment env_execute

      action :nothing
    end

    remote_directory "/tmp/repos/#{new_resource.files}" do
      source "local_repos/#{new_resource.files}"
      recursive true

      notifies :run, "execute[aptly repo add #{new_resource.repo_name}]", :immediately
    end

    snapshot_name = "#{new_resource.repo_name}-#{Time.now.strftime '%Y-%m'}"
    execute "aptly snapshot create #{new_resource.repo_name}" do
      command "aptly snapshot create #{snapshot_name} from repo #{new_resource.repo_name}"

      user node['aptly']['user']
      group node['aptly']['group']

      extend SdsAptly::Helpers
      environment env_execute

      not_if "aptly snapshot list -raw | grep ^#{snapshot_name}$"
    end
  end

end
