#
# Cookbook:: sds_sensu
# Recipe:: default
#
# Copyright:: 2017, Curse, All Rights Reserved.

user node["sensu"]["user"] do
  password Sensu::Helpers.random_password(20, true, true, true, true)
  not_if { Sensu::Helpers.windows_user_exists?(node["sensu"]["user"]) }
end

group node["sensu"]["group"] do
  members node["sensu"]["user"]
  append true
  action :manage
end

powershell_script 'install_dot_net_3-5' do
  code <<-EOH
    Install-WindowsFeature -name NET-Framework-Core
  EOH
  not_if <<-EOH
    (Get-WindowsFeature -name NET-Framework-Core).Installed
  EOH
end

directory '/temp'

s3_file '/temp/sensu-1.4.2-1-x64.msi' do
  key 'sensu/sensu-1.4.2-1-x64.msi'
end

windows_package 'Sensu' do
  source '/temp/sensu-1.4.2-1-x64.msi'
  action :install
  installer_type :msi
  options '/quiet /passive /norestart'
  checksum 'f2377ae3cc7cf2acf074f4b9343263cd1c3cf840e71ca5ca08cadcddf463550a'
end

%w(log_directory config_directory secret_directory).each do |dir|
  directory node['sensu'][dir] do
    owner node['sensu']['user']
    group node['sensu']['group']
    mode 00750

    recursive true
  end
end

file 'sensu/config.json' do
  path File.join(node['sensu']['config_directory'], 'config.json')
  content node['sensu']['common_config'] ? JSON.pretty_generate(node['sensu']['common_config']) : ''
end

cookbook_file File.join(node['sensu']['config_directory'], 'bin' ,'sensu-client.xml') do
  source 'sensu-client.xml'
end

%w(conf.d plugins).each do |folder|
  directory File.join(node['sensu']['config_directory'], folder) do
    recursive true
  end
end

execute "sensu-client.exe install" do
  cwd 'C:\opt\sensu\bin'
  not_if { Sensu::Helpers.windows_service_exists?("sensu-client") }
end

##TODO Work out a way to get rid of DelayedAutoStart
registry_key 'HKEY_LOCAL_MACHINE\System\CurrentControlSet\Services\sensu-client' do
  values [{
              :name => 'DelayedAutoStart',
              :type => :dword,
              :data => 1
          },
          {
              :name => "DependOnService",
              :type => :multi_string,
              :data => ['LanmanServer', 'DnsCache']
          }]
  action :create
end

file 'sensu/client.json'  do
  path File.join(node['sensu']['config_directory'], 'conf.d', 'client.json')
  content lazy { JSON.pretty_generate(:client => node['sensu']['client_config']) }

  notifies :restart, node['sensu']['service_cmd'], :delayed
end

directory File.join(node['sensu']['config_directory'], 'extensions')

service 'sensu-client' do
  supports :restart => true, :status => true
  action [:enable, :start]

  retries 3
  retry_delay 5

  ignore_failure true

  subscribes :restart, 'file[sensu/config.json]', :delayed
end

