unless ENV['TEST_KITCHEN']
    default['homebrew']['owner'] = 'csi'
else
    default['homebrew']['owner'] = 'vagrant'
end

# Packages
# default['teamcity']['packages']['server']['url'] = 'https://s3.amazonaws.com/cursecomms/LinuxPackages/TeamCity-2018.2.tar.gz'
default['teamcity']['packages']['server']['s3']['key'] = 'teamcity/server/TeamCity-2019.1.5.tar.gz'
default['teamcity']['packages']['server']['checksum'] = 'd9491d46fa8a431fdf46a8471faa28f6ba080f55a4035df0415099105e35040d'

# default['teamcity']['packages']['jdbc']['url'] = 'https://s3.amazonaws.com/cursecomms/LinuxPackages/mysql-connector-java-5.1.40-bin.jar'
default['teamcity']['packages']['jdbc']['s3']['key'] = 'teamcity/deps/mysql-connector-java-5.1.40-bin.jar'
default['teamcity']['packages']['jdbc']['checksum'] = '83232082a005492a0f01678d08d5426afae716af2d47e799e06444e1a9db6350'

# default['teamcity']['packages']['oauth_plugin']['url'] = 'https://s3.amazonaws.com/cursecomms/LinuxPackages/teamcity-oauth.zip'
default['teamcity']['packages']['oauth_plugin']['s3']['key'] = 'teamcity/plugins/teamcity-oauth.zip'
default['teamcity']['packages']['oauth_plugin']['checksum'] = '88b4f1dbc38bfe0ebf53af6ccc96890ba01159df2a1814e8b8a712276c3d533d'

# default['teamcity']['packages']['ghe_hook_plugin']['url'] = 'https://s3.amazonaws.com/cursecomms/LinuxPackages/teamcity-commit-hooks.zip'
default['teamcity']['packages']['ghe_hook_plugin']['s3']['key'] = 'teamcity/plugins/teamcity-commit-hooks.zip'
default['teamcity']['packages']['ghe_hook_plugin']['checksum'] = '439c1058a39676401672a18d6532081d8882b2f08ee659d52d32c61e392213b6'

# default['teamcity']['packages']['saucelabs_plugin']['url'] = 'https://s3.amazonaws.com/cursecomms/LinuxPackages/saucelabs-ondemand-1.41.zip'
default['teamcity']['packages']['saucelabs_plugin']['s3']['key'] = 'teamcity/plugins/saucelabs-ondemand-1.41.zip'
default['teamcity']['packages']['saucelabs_plugin']['checksum'] = 'a09617eecc34f97e0643ca3c4c169cb50ef6f88e6a8e9dd7bfd0f25a828c9a98'

# default['teamcity']['packages']['agent']['url'] = 'https://s3.amazonaws.com/cursecomms/LinuxPackages/buildAgent.zip'
default['teamcity']['packages']['agent']['s3']['key'] = 'teamcity/agent/buildAgent.zip'
default['teamcity']['packages']['agent']['checksum'] = '66aa8b654b980e6ab9ffd3c68d69290ab1040821962299122880fd1b4ac89ff3'

# This is in an s3 bucket since Microsoft removed this download
default['teamcity']['packages']['subinacl']['s3']['key'] = 'microsoft/subinacl.msi'
default['teamcity']['packages']['subinacl']['checksum'] = 'EA6AE1C19B2A51677662D38CE7DA7E7AFFF89A275DA4E06E3B7FD519DA8E9AC7'

# default['teamcity']['packages']['agent_win']['url'] = 'https://s3.amazonaws.com/cursecomms/WindowsPackages/agentInstaller.exe'
default['teamcity']['packages']['agent_win']['s3']['key'] = 'teamcity/agent/agentInstaller.exe'
default['teamcity']['packages']['agent_win']['checksum'] = '90450d773c7571bfc3cb942fcad92522fcee43ffd26af71f84d625d73a8269d8'

# default['teamcity']['packages']['merge_pull_request']['url'] = 'https://s3.amazonaws.com/cursecomms/LinuxPackages/merge-pull-request-trigger.zip'
default['teamcity']['packages']['merge_pull_request']['s3']['key'] = 'teamcity/plugins/merge-pull-request-trigger.zip'
default['teamcity']['packages']['merge_pull_request']['checksum'] = '4441a18b9a6bdbc1984534d643117f9eb1a710c07787fa77a55ec935f22bcb45'

# Java Config
default['java']['jdk_version'] = '8'
default['java']['install_flavor'] = value_for_platform_family('windows' => 'windows', 'mac_os_x' => 'homebrew') || 'openjdk'

# Agent Config
default['teamcity']['agent']['server_uri'] = 'https://teamcity.xarth.tv'
default['teamcity']['agent']['work_dir'] = '/opt/jetbrains/TeamCity_agent/work'
default['teamcity']['agent']['temp_dir'] = '/opt/jetbrains/TeamCity_agent/temp'
default['teamcity']['agent']['system_dir'] = '/opt/jetbrains/TeamCity_agent/system'
default['teamcity']['agent']['own_port'] = '1337'

default['teamcity']['agent']['token'] = nil
default['teamcity']['agent']['system_properties'] = Hash.new
default['teamcity']['agent']['env_properties'] = Hash.new

default['teamcity']['agent']['user_password'] = nil
default['teamcity']['agent']['user_token'] = nil
