s3_file "/opt/jetbrains/packages/#{File.basename(node['teamcity']['packages']['agent']['s3']['key'])}" do
  key node['teamcity']['packages']['agent']['s3']['key']
  checksum node['teamcity']['packages']['agent']['checksum']
  not_if { File.exist? "/opt/jetbrains/packages/#{File.basename(node['teamcity']['packages']['agent']['s3']['key'])}" }
end

package 'unzip'
package 'subversion'

execute 'extract_agent' do
  command "unzip /opt/jetbrains/packages/#{File.basename(node['teamcity']['packages']['agent']['s3']['key'])} && chown -R teamcity:teamcity /opt/jetbrains/TeamCity_agent"
  cwd '/opt/jetbrains/TeamCity_agent'
  not_if { File.exists?( "/opt/jetbrains/TeamCity_agent/bin/agent.sh" ) }
end

execute 'systemctl daemon-reload' do
  action :nothing
end

cookbook_file '/etc/systemd/system/teamcity-agent.service' do
  source 'teamcity-agent.service'
  mode 0700

  notifies :run, 'execute[systemctl daemon-reload]', :delayed
end

ruby_block 'read existing token from agent configuration' do
  block do
    begin
      current_conf = ::File.read('/opt/jetbrains/TeamCity_agent/conf/buildAgent.properties')
      node.override['teamcity']['agent']['token'] = current_conf.match(/^authorizationToken=(.*)$/)[1]
    rescue
    end
  end
end

template '/opt/jetbrains/TeamCity_agent/conf/buildAgent.properties' do
  source 'buildAgent.properties.erb'
  mode 0600
  owner 'teamcity'
  group 'teamcity'

  helper(:server_uri) { node['teamcity']['agent']['server_uri'] }
  helper(:name) { node['hostname'] }
  helper(:work_dir) { node['teamcity']['agent']['work_dir'] }
  helper(:temp_dir) { node['teamcity']['agent']['temp_dir'] }
  helper(:system_dir) { node['teamcity']['agent']['system_dir'] }
  helper(:own_port) { node['teamcity']['agent']['own_port'] }
  helper(:authorization_token) { node['teamcity']['agent']['token'] }
  helper(:system_properties) { node['teamcity']['agent']['system_properties'] }
  helper(:env_properties) { node['teamcity']['agent']['env_properties'] }

  notifies :restart, 'service[teamcity-agent]', :delayed

end

service 'teamcity-agent' do
  action [:enable, :start]
end
