#
# Cookbook:: sds_teamcity
# Recipe:: default
#
# Copyright:: 2017, Curse, All Rights Reserved.

directory('/opt/jetbrains') { recursive true }

case node['platform']

when 'windows'

  chocolatey_package 'git'
  chocolatey_package 'jdk8'

when 'mac_os_x'
  # homebrew java8 cask no longer exists
  # include_recipe 'java'

  homebrew_tap 'homebrew/cask-versions'
  homebrew_tap 'homebrew/cask'
  # From homebrew 2.7, calling "brew cast install" command is deprecated,
  # we're using calling a bash command instead. Rollback when homebrew_cast
  # adopt the new change.
  #
  #homebrew_cask 'adoptopenjdk8' do
  #  install_cask false
  #end
  #
  bash 'adoptopenjdk8' do
    code 'brew  install --cask adoptopenjdk8'
    environment 'PATH' => "/usr/local/bin:#{ENV['PATH']}"
    user node['homebrew']['owner']
  end
else
  include_recipe 'apt' if node['platform'].eql?('ubuntu')
  include_recipe 'java'

  group 'teamcity' do
    gid 15000
    not_if "grep -q 'teamcity:' /etc/group"
  end

  user 'teamcity' do
    uid 15000
    gid 15000
    manage_home true
    home '/opt/jetbrains/TeamCity'
    shell '/bin/bash'
    password ''
    notifies :run, 'execute[del-teamcity-pw]', :immediately
  end

  directory '/opt/jetbrains/TeamCity' do
    mode 0700
    owner 'teamcity'
    group 'teamcity'
  end

  execute 'del-teamcity-pw' do
    command '/usr/bin/passwd -d teamcity'
    action :nothing
  end
end

directory '/opt/jetbrains/packages'
directory '/opt/jetbrains/TeamCity_agent'

