# Set default region
ENV['AWS_REGION'] = if node['ec2'].nil? || node['ec2']['region'].nil?
                      'us-west-2'
                    else
                      node['ec2']['region']
                    end

require 'aws-sdk-ssm'
ssm = Aws::SSM::Client.new

include_recipe 'sudo' # required for test-kitchen due to al2/centos sudo oddities

yum_package 'java-1.8.0-openjdk-devel'

include_recipe 'jenkins::master'

# simple hack to determine if we need to authenticate
if File.exist?('/var/lib/jenkins/jenkins.yaml')
  # Username parameter should be defined in our CDK project
  node.run_state[:jenkins_username] = ssm.get_parameter(
    name: node['jenkins_master']['ssm_params']['username']
  ).parameter.value

  # Password parameter has to be created manually to enable encryption
  node.run_state[:jenkins_password] = ssm.get_parameter(
    name: node['jenkins_master']['ssm_params']['password'],
    with_decryption: true
  ).parameter.value
end

include_recipe '::plugins'

# configuration-as-code yaml file
template '/var/lib/jenkins/jenkins.yaml' do
  source 'jenkins.yaml.erb'
  variables(
    master_domain_name: node['jenkins_master']['domain_name'],
    github_client_id: node['jenkins_master']['ssm_params']['github_client_id'],
    github_client_secret: node['jenkins_master']['ssm_params']['github_client_secret']
  )
  owner 'jenkins'
  group 'jenkins'
  notifies :restart, 'service[jenkins]', :delayed
  sensitive true
end

include_recipe '::awslogs'
