# InSpec test for recipe app_jenkins_master::default

# The InSpec reference, with examples and extensive documentation, can be
# found at https://www.inspec.io/docs/reference/resources/

require 'rspec/retry'

describe directory('/var/lib/jenkins') do
  it { should exist }
end

describe package('jenkins') do
  it { should be_installed }
end

describe service('jenkins') do
  it { should be_installed }
  it { should be_enabled }
  it { should be_running }
end

# Jenkins should be listening on port 8080
describe 'Port 8080' do
  it 'is expected to be listening', retry: 10, retry_wait: 6 do
    expect(port(8080).listening?).to eq true
  end
end
