#
# Cookbook:: base_server_mac
# Recipe:: default
#
# Copyright:: 2020, Twitch, All Rights Reserved.

include_recipe 'macos::keep_awake'

automatic_software_updates 'disable software updates' do
  check false
  download false
  install_os false
  install_app_store false
  install_critical false
end

# automatic_software_updates resource doesn't set this properly on first run
execute 'extra_disable_macos_updates' do
  command 'defaults write /Library/Preferences/com.apple.SoftwareUpdate AutomaticallyInstallMacOSUpdates 0'
  not_if 'defaults read /Library/Preferences/com.apple.SoftwareUpdate AutomaticallyInstallMacOSUpdates | egrep -q "^0$"'
end

# TODO: move this out to the teamcity agent cookbook
# build_essential 'Install Xcode CLI Tools' do
#   compile_time true
# end

execute 'disable_login_screensaver' do
  command 'defaults write /Library/Preferences/com.apple.screensaver loginWindowIdleTime 0'
  not_if 'defaults read /Library/Preferences/com.apple.screensaver loginWindowIdleTime | egrep -q "^0$"'
end

include_recipe 'homebrew'

group 'homebrew' do
  not_if "grep -q 'homebrew:' /etc/group"
end

# homebrew_package 'zsh'

cookbook_file '/etc/profile' do
  source 'profile'
end

include_recipe '::admins'
# include_recipe '::monitoring'

# TODO: move this out to the teamcity agent cookbook
# include_recipe '::dnsmasq'

execute 'fix brew permissions' do
  command <<-EOH
  chgrp -R homebrew /usr/local/*
  chmod -R g+w /usr/local/*
  EOH
end
