## Install
aws_sensu = chef_vault_item('aws', 'sensu')
node.default['sensu']['common_config']['snssqs']['access_key_id'] = aws_sensu[:access_key]
node.default['sensu']['common_config']['snssqs']['secret_access_key'] = aws_sensu[:secret_key]

include_recipe 'sensu'

sensu_gem 'sensu-transport-snssqs-ng'

sensu_snippet 'snssqs' do
  content node['sensu']['common_config']['snssqs']
end

sensu_client node.name do
  address node['ipaddress']
  subscriptions []
  additional node['sensu']['client_options']
end

include_recipe 'sensu::client_service'

sensu_gem 'sensu-plugins-disk-checks'
homebrew_package 'nagios-plugins'

## Checks

sensu_check 'disk-check-macos' do
  command '/opt/sensu/embedded/bin/ruby /opt/sensu/embedded/bin/check-disk-usage.rb -x vmhgfs'
  standalone true
  handlers [node['sensu']['client_options']['keepalive']['handler']]
  interval 30
  additional(occurrences: 3)
end

sensu_check 'zombieproc-check-macos' do
  command '/usr/local/sbin/check_procs -c0 -sZ'
  standalone true
  handlers [node['sensu']['client_options']['keepalive']['handler']]
  interval 30
  additional(occurrences: 3)
end
