# InSpec test for recipe base_server_mac::default

# The InSpec reference, with examples and extensive documentation, can be
# found at https://www.inspec.io/docs/reference/resources/

# Auto-update check and OS settings disabled
# describe plist('/Library/Preferences/com.apple.SoftwareUpdate.plist') do
#   its('AutomaticCheckEnabled') { should eq false }
#   its('AutomaticDownload') { should eq false }
#   its('AutomaticallyInstallMacOSUpdates') { should eq false }
#   its('CriticalUpdateInstall') { should eq false }
# end

# Workaround b/c ruby can't parse this plist due to invalid characters
['AutomaticCheckEnabled', 'AutomaticDownload', 'AutomaticallyInstallMacOSUpdates', 'CriticalUpdateInstall'].each do |setting|
  describe command("defaults read /Library/Preferences/com.apple.SoftwareUpdate.plist #{setting}") do
    its('stdout') { should eq "0\n" }
  end
end

# AppStore auto-update disabled
describe command('defaults read /Library/Preferences/com.apple.commerce.plist AutoUpdate') do
  its('stdout') { should eq "0\n" }
end

# MacOS Login screensaver disabled
describe command('defaults read /Library/Preferences/com.apple.screensaver.plist loginWindowIdleTime') do
  its('stdout') { should eq "0\n" }
end

describe group('homebrew') do
  it { should exist }
end

describe file('/usr/local/bin/brew') do
  it { should exist }
end

describe file('/etc/profile') do
  it { should exist }
  its('content') { should eq File.open('files/profile').read }
end
