# Required
variable "account" {}
variable "environment" {}
variable "service" {}
variable "vpc" {}
variable "protocol" {}
variable "subnets" { type = "list" }
variable "security_groups" { type = "list" }
variable "target_group_port" {}
variable "lisener_port" {}
variable "healthy_threshold" {}
variable "unhealthy_threshold" {}
variable "health_check_timeout" {}
variable "health_check_path" {}
variable "health_check_interval" {}
variable "health_check_port" {}

# Optional
variable "region" { default = "us-west-2" }
variable "alert_arn" { type = "list" }

# Utility vars
# For use with creating FQDNs
variable "env_shortname" {
  type = "map"
  default = {
    production = "prod"
    staging = "staging"
    development = "dev"
  }
}

# Output data
output "alb_fqdn" { value = "${aws_route53_record.alb_dns.fqdn}" }
output "alb_name" { value = "${aws_lb.alb.name}" }
output "target_group_arn" { value = "${aws_lb_target_group.alb_target_group.arn}" }
