# Devsite-RBAC-TF

Terraform files for devrel/devsite-rbac

## Usage

### Getting Started

Dependencies:

- [chtf](https://github.com/Yleisradio/homebrew-terraforms): Easily install the latest version of terraform via `chtf 0.11.10`.
- [landscape](https://github.com/coinbase/terraform-landscape): Helpful tool that makes reading terraform plans easier https://github.com/coinbase/terraform-landscape.
- terraform: via chtf.

The project is separated into `modules`, `production`, and `staging`. Modules contained code that is used by `production` and `staging`. `production` and `staging` are their respective environments. Applying terraform changes in those directories will change production and staging. Each environment folder is broken down into components such as account and

### Execution

1. Move to the directory where you want to apply changes.
1. `terraform init`
1. `terraform plan | landscape`. check the output and make sure it is as you expect.
1. `terraform apply`

### Contributing

Please have code reviewed before applying to production. Staging can be applied to for testing without review. Please run `terraform fmt`.

## Known issues

- Changes were made to get production terraform working, staging may need refactoring.
- The RBAC dev aws account do not have terraform files at the account level.
- Using the identity/tf_beanstalk module prevents us from getting some much needed outputs. The plan is to rewrite later without that module.
