module "beanstalk" {
  source                           = "git::git+ssh://git@git-aws.internal.justin.tv/identity/tf_beanstalk.git//environment?ref=v1.5.0"
  env                              = "${var.environment}"
  vpc_id                           = "${lookup(data.terraform_remote_state.systems.vpc_id, var.aws_region)}"
  ec2_subnet_ids                   = "${join(",", data.terraform_remote_state.systems.private_subnets[var.aws_region])}"
  elb_subnet_ids                   = "${join(",", data.terraform_remote_state.systems.private_subnets[var.aws_region])}"
  elb_loadbalancer_security_groups = "${coalesce(var.override_security_group, data.terraform_remote_state.systems.twitch_subnets_sg_id[var.aws_region])}"
  auto_scaling_lc_security_groups  = "${coalesce(var.override_security_group, data.terraform_remote_state.systems.twitch_subnets_sg_id[var.aws_region])}"
  asg_min_size                     = "${var.server_asg_min_size}"
  asg_max_size                     = "${var.server_asg_max_size}"
  iam_role_id                      = "${var.iam_role_id}"
  iam_role_arn                     = "${var.iam_role_arn}"
  instance_type                    = "${var.instance_type}"
  app_name                         = "rbac"
  aws_profile                      = "${var.aws_profile}"
  aws_region                       = "${var.aws_region}"
  solution_stack_name              = "${var.platform_version}"
  deploy_batch_size_type           = "${var.deploy_batch_size_type}"
  deploy_batch_size                = "${var.deploy_batch_size}"
  deploy_timeout                   = "${var.deploy_timeout}"
  environment_suffix               = "${var.environment_suffix}"
}

output "canary_name" {
  value = "${module.beanstalk.canary_name}"
}
