variable "environment" {
  default = "staging"
}

variable "new_account_environment" {
  default = "dev"
}

variable "server_asg_min_size" {
  default = 2
}

variable "server_asg_max_size" {
  default = 4
}

variable "instance_type" {
  default = "c4.2xlarge"
}

variable "aws_profile" {}

variable "aws_region" {}

variable "iam_role_id" {}

variable "iam_role_arn" {}

variable "override_security_group" {
  default = ""
}

variable "platform_version" {}

variable "deploy_batch_size_type" {
  description = "The type of number that is specified in BatchSize. Either 'fixed' or 'percentage'"
  default     = "Percentage"
}

variable "deploy_batch_size" {
  description = "Percentage or fixed number of Amazon EC2 instances in the Auto Scaling group on which to simultaneously perform deployments. Valid values vary per BatchSizeType setting."
  default     = 25
}

variable "deploy_timeout" {
  description = "Number of seconds to wait for an instance to complete executing commands"
  default     = 600
}
