resource "aws_db_instance" "db-master" {
  allocated_storage = "${var.allocated_storage}"
  engine = "${var.engine}"
  engine_version = "${var.engine_version}"
  identifier = "${var.name}-${var.environment}-master"
  instance_class = "${var.instance_type}"
  storage_type = "${var.storage_type}"
  iops = "${var.iops}"
  username = "${var.username}"
  password = "${var.password}"
  port = "${var.port}"
  db_subnet_group_name = "${aws_db_subnet_group.db-subnet.name}"
  multi_az = "${var.multi_az}"
  publicly_accessible = "${var.publicly_accessible}"
  backup_retention_period = "${var.backup_retention_period}"
  vpc_security_group_ids = "${var.vpc_security_groups}"
}

/*
resource "aws_db_instance" "db-replica-1" {
  replicate_source_db = "${aws_db_instance.db-master.identifier}"
  allocated_storage = "${var.allocated_storage}"
  engine = "${var.engine}"
  engine_version = "${var.engine_version}"
  identifier = "${var.name}-${var.environment}-replica-1"
  instance_class = "${var.instance_type}"
  storage_type = "${var.storage_type}"
  iops = "${var.iops}"
  username = "${var.username}"
  password = "${var.password}"
  port = "${var.replica_port}"
  publicly_accessible = "${var.publicly_accessible}"
  vpc_security_group_ids = "${var.vpc_security_groups}"
}
*/

resource "aws_db_subnet_group" "db-subnet" {
  name = "${var.name}-${var.environment}-subnet"
  description = "RBAC DB subnets"
  subnet_ids = "${var.private_subnets}"

  tags {
    "Owner" = "scoakley@justin.tv"
  }
}
