resource "aws_route_table" "external_routes" {
  vpc_id = "${var.rbac_vpc_id}"

  route {
    cidr_block = "0.0.0.0/0"
    gateway_id = "${var.rbac_igw_id}"
  }

  route {
    cidr_block = "10.0.0.0/8"
    gateway_id = "${var.rbac_vgw_id}"
  }

  route {
    cidr_block                = "10.197.192.0/18"
    vpc_peering_connection_id = "${var.central_peering_connection}"
  }

  route {
    cidr_block                = "${var.categoriesdb_cidr}"
    vpc_peering_connection_id = "${var.categoriesdb_peering_connection}"
  }

  # twitch-graphql-prod
  route {
    cidr_block                = "${var.graphql_cidr}"
    vpc_peering_connection_id = "${var.graphql_peering_connection}"
  }

  route {
    cidr_block = "23.160.0.0/24"
    gateway_id = "${var.rbac_vgw_id}"
  }

  route {
    cidr_block = "45.113.128.0/22"
    gateway_id = "${var.rbac_vgw_id}"
  }

  route {
    cidr_block = "52.223.192.0/20"
    gateway_id = "${var.rbac_vgw_id}"
  }

  route {
    cidr_block = "52.223.208.0/21"
    gateway_id = "${var.rbac_vgw_id}"
  }

  route {
    cidr_block = "52.223.216.0/21"
    gateway_id = "${var.rbac_vgw_id}"
  }

  route {
    cidr_block = "52.223.224.0/20"
    gateway_id = "${var.rbac_vgw_id}"
  }

  route {
    cidr_block = "52.223.240.0/20"
    gateway_id = "${var.rbac_vgw_id}"
  }

  route {
    cidr_block = "103.53.48.0/22"
    gateway_id = "${var.rbac_vgw_id}"
  }

  route {
    cidr_block = "172.24.20.0/22"
    gateway_id = "${var.rbac_vgw_id}"
  }

  route {
    cidr_block = "185.42.204.0/22"
    gateway_id = "${var.rbac_vgw_id}"
  }

  route {
    cidr_block = "192.16.64.0/21"
    gateway_id = "${var.rbac_vgw_id}"
  }

  route {
    cidr_block = "192.108.239.0/24"
    gateway_id = "${var.rbac_vgw_id}"
  }

  route {
    cidr_block = "192.168.0.0/17"
    gateway_id = "${var.rbac_vgw_id}"
  }

  route {
    cidr_block = "192.168.128.0/21"
    gateway_id = "${var.rbac_vgw_id}"
  }

  route {
    cidr_block = "192.168.144.0/21"
    gateway_id = "${var.rbac_vgw_id}"
  }

  route {
    cidr_block = "192.168.240.0/21"
    gateway_id = "${var.rbac_vgw_id}"
  }

  route {
    cidr_block = "199.9.248.0/21"
    gateway_id = "${var.rbac_vgw_id}"
  }

  propagating_vgws = ["${var.rbac_vgw_id}"]

  tags {
    Name = "external"
  }
}

resource "aws_route_table_association" "external_a" {
  subnet_id      = "${var.subnet_external["a"]}"
  route_table_id = "${aws_route_table.external_routes.id}"
}

resource "aws_route_table_association" "external_b" {
  subnet_id      = "${var.subnet_external["b"]}"
  route_table_id = "${aws_route_table.external_routes.id}"
}

resource "aws_route_table_association" "external_c" {
  subnet_id      = "${var.subnet_external["c"]}"
  route_table_id = "${aws_route_table.external_routes.id}"
}
