terraform {
  backend "s3" {
    bucket = "twitch-rbac-prod"
    key    = "tfstate/devsite/rbac-terraform/production/beanstalk"
    region = "us-west-2"
    profile = "twitch-rbac-prod"
  }
}

module "beanstalk" {
  source                           = "git::git+ssh://git@git-aws.internal.justin.tv/identity/tf_beanstalk.git//environment_single?ref=v1.5.1"
  owner                            = "scoakley@justin.tv"
  service                          = "devsite/rbac"
  env                              = "production"
  vpc_id                           = "vpc-dd68e2ba"
  ec2_subnet_ids                   = "subnet-dadf71bd,subnet-c28a4a8b,subnet-20bd9278"
  elb_subnet_ids                   = "subnet-5562f12c,subnet-ad0db0e6,subnet-b1d5bfeb"
  elb_loadbalancer_security_groups = "sg-270c9c5f"
  auto_scaling_lc_security_groups  = "sg-270c9c5f"
  asg_min_size                     = "3"
  asg_max_size                     = "12"
  iam_role_id                      = "${aws_iam_role.rbac.id}"
  iam_role_arn                     = "${aws_iam_role.rbac.arn}"
  app_name                         = "rbac"
  instance_type                    = "c4.2xlarge"
  aws_profile                      = "twitch-rbac-prod"
  aws_region                       = "us-west-2"
  solution_stack_name              = "64bit Amazon Linux 2018.03 v2.9.4 running Go 1.11.4"
  deploy_batch_size_type           = "Percentage"
  deploy_batch_size                = 25
  deploy_timeout                   = 600
  healthcheck_url                  = ""
}

resource "aws_iam_role" "rbac" {
  name = "rbac-us-west-2"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_role_policy" "sandstorm" {
  name = "rbac-sandstorm"
  role = "${aws_iam_role.rbac.id}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Sid": "",
      "Effect": "Allow",
      "Action": "sts:AssumeRole",
      "Resource": "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/sandstorm-agent-devsite-rbac-staging"
    }
  ]
}
EOF
}

data "aws_iam_policy_document" "sns_publish" {
  statement {
    sid = "snspublish"
    actions = [
      "sns:Publish"
    ]
    resources = [
      "arn:aws:sns:us-west-2:603200399373:pushy_production_dispatch"
    ]
  }
}

resource "aws_iam_role_policy" "sns_publish" {
  name = "sns_publish"
  role = "${aws_iam_role.rbac.id}"
  policy = "${data.aws_iam_policy_document.sns_publish.json}"
}

data "aws_iam_policy" "AmazonEC2RoleforSSM" {
  arn = "arn:aws:iam::aws:policy/service-role/AmazonEC2RoleforSSM"
}

resource "aws_iam_role_policy_attachment" "ssm-attachment" {
  role = "${aws_iam_role.rbac.id}"
  policy_arn = "${data.aws_iam_policy.AmazonEC2RoleforSSM.arn}"
}
