terraform {
  backend "s3" {
    bucket = "twitch-rbac-prod"
    key    = "tfstate/devsite/rbac-terraform/production/db"
    region = "us-west-2"
    profile = "twitch-rbac-prod"
  }
}

module "rds" {
  name = "rbac"
  source = "../../modules/db"
  aws_profile = "twitch-rbac-prod"
  aws_region = "us-west-2"
  allocated_storage = 250
  engine = "postgres"
  engine_version = "9.5.2"
  environment = "production"
  new_account_environment = "prod"
  instance_type = "db.m4.large"
  storage_type = "io1"
  iops = "1000"
  username = "rbac_admin"
  password = "${var.password}"
  port = "5433"
  //replica_port = "5434"
  storage_type = "io1"
  multi_az = "false"
  publicly_accessible = "false"
  backup_retention_period = "14"

  vpc_security_groups = ["sg-270c9c5f"]
  private_subnets = ["subnet-dadf71bd","subnet-c28a4a8b","subnet-20bd9278"]

  //snapshot_identifier = "${var.snapshot}"
}
