terraform {
  backend "s3" {
    bucket = "twitch-rbac-dev"
    key    = "tfstate/devsite/rbac-terraform/staging/beanstalk"
    region = "us-west-2"
    profile = "twitch-rbac-dev"
  }
}

module "beanstalk" {
  source                           = "git::git+ssh://git@git-aws.internal.justin.tv/identity/tf_beanstalk.git//environment_single"
  owner                            = "scoakley@justin.tv"
  service                          = "devsite/rbac"
  env                              = "staging"
  vpc_id                           = "vpc-5855df3f"
  ec2_subnet_ids                   = "subnet-3cccc474,subnet-85de70e2,subnet-e6be91be"
  elb_subnet_ids                   = "subnet-39cec671,subnet-cfd23bb6,subnet-23bf6079"
  elb_loadbalancer_security_groups = "sg-a70b9bdf"
  auto_scaling_lc_security_groups  = "sg-a70b9bdf"
  asg_min_size                     = "2"
  asg_max_size                     = "5"
  iam_role_id                      = "${aws_iam_role.rbac.id}"
  iam_role_arn                     = "${aws_iam_role.rbac.arn}"
  app_name                         = "rbac"
  instance_type                    = "c4.2xlarge"
  aws_profile                      = "twitch-rbac-dev"
  aws_region                       = "us-west-2"
  solution_stack_name              = "64bit Amazon Linux 2018.03 v2.9.4 running Go 1.11.4"
  deploy_batch_size_type           = "Percentage"
  deploy_batch_size                = 50
  deploy_timeout                   = 600
  healthcheck_url                 = ""
}

resource "aws_iam_role" "rbac" {
  name = "rbac-us-west-2"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

data "aws_iam_policy_document" "sns_publish" {
  statement {
    sid = "snspublish"
    actions = [
      "sns:Publish"
    ]
    resources = [
      "arn:aws:sns:us-west-2:603200399373:pushy_darklaunch_dispatch"
    ]
  }
}

resource "aws_iam_role_policy" "sns_publish" {
  name = "sns_publish"
  role = "${aws_iam_role.rbac.id}"
  policy = "${data.aws_iam_policy_document.sns_publish.json}"
}

data "aws_iam_policy" "AmazonEC2RoleforSSM" {
  arn = "arn:aws:iam::aws:policy/service-role/AmazonEC2RoleforSSM"
}

resource "aws_iam_role_policy_attachment" "ssm-attachment" {
  role = "${aws_iam_role.rbac.id}"
  policy_arn = "${data.aws_iam_policy.AmazonEC2RoleforSSM.arn}"
}
