terraform {
  backend "s3" {
    bucket = "twitch-rbac-dev"
    key    = "tfstate/devsite/rbac-terraform/staging/db"
    region = "us-west-2"
    profile = "twitch-rbac-dev"
  }
}

module "rds" {
  name = "rbac"
  source = "../../modules/db"
  aws_profile = "twitch-rbac-dev"
  aws_region = "us-west-2"
  allocated_storage = 500
  engine = "postgres"
  engine_version = "9.5.2"
  environment = "staging"
  new_account_environment = "dev"
  instance_type = "db.r4.large"
  storage_type = "io1"
  iops = "2000"
  username = "rbac_admin"
  password = "${var.password}"
  port = "5433"
  //replica_port = "5434"
  storage_type = "io1"
  multi_az = "false"
  publicly_accessible = "false"
  backup_retention_period = "14"

  //snapshot_identifier = "${var.snapshot}"
}
