package test

// How to run this test:
//  * cd test
//  * rm *.gen.go
//  * go test ./...
//  * rm db_db_errxer.gen.go (has a package issue).
//  * go test ./... (again, to verify generated code compiles).
// Take a look a the generated files.

import (
	"fmt"
	"os"
	"os/exec"
	"strings"
	"testing"
)

// This test generates some files that you can use for inspection after runing the test.
func TestGenerate(t *testing.T) {
	// Generate some interface wrappers
	runErrxer(t, "Simple")
	runErrxer(t, "PackagePrivate")
	runErrxer(t, "Discovery")

	// Generate from another package
	// NOTE: make sure to go get code.justin.tv/chat/db before.
	// NOTE: db_db_errxer.go needs to be removed before re-running tests because it uses a different pacakage
	runErrxer(t, "code.justin.tv/chat/db.DB")

	// Generate with timings
	runErrxer(t, "DoStuffTimings", "--timings")
}

func runErrxer(t *testing.T, intrfc string, flags ...string) {
	cmdParts := []string{"go", "run", "../cmd/errxer/main.go"}
	cmdParts = append(cmdParts, flags...)
	cmdParts = append(cmdParts, intrfc)
	fmt.Println("Running: ", strings.Join(cmdParts, " "))

	cmd := exec.Command(cmdParts[0], cmdParts[1:]...)
	cmd.Stdout = os.Stdout
	cmd.Stderr = os.Stderr

	if err := cmd.Run(); err != nil {
		t.Fatal(err)
	}
}
