freeStyleJob('devrel-helloworld') {
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'devrel/helloworld', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell './jenkins.sh'
    conditionalSteps {
      condition {
        shell 'test $GIT_BRANCH = "origin/master" && ./vendor/code.justin.tv/twitch/ecs-deploy/helpers/is-new-deploy.sh devrel helloworld $GIT_COMMIT'
      }
      runner('DontRun')
      steps {
        downstreamParameterized {
          trigger('devrel-helloworld-pipeline') {
            parameters {
              predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
            }
          }
        }
      }
    }
  }
}

