provider "jenkins" {
  url                = "https://jenkins.internal.justin.tv"
  shared_credentials = "${file(pathexpand("~/.jenkins_auth"))}"
}

terraform {
  backend "s3" {
    bucket  = "twitch-rbac-prod"
    key     = "devrel/helloworld-pipeline.tfstate"
    region  = "us-west-2"
    profile = "twitch-rbac-prod"
  }
}

module "pipeline" {
  source         = "git::git+ssh://git@git-aws.internal.justin.tv/twitch/terraform//promotion_pipeline?ref=v0.6.5"
  team           = "devrel"
  service        = "helloworld"
  git_repository = "https://git-aws.internal.justin.tv/devrel/helloworld"
}
