locals {
  owner   = "kevipike@twitch.tv"
  team    = "devrel"
  region  = "us-west-2"
  service = "helloworld"

  account_ids = {
    canary = "712827439730"
  }

  profiles = {
    canary = "twitch-rbac-prod"
  }

  min_counts = {
    canary = "1"
  }

  desired_counts = {
    canary = "1"
  }

  max_counts = {
    canary = "1"
  }

  auto_promotes = {
    canary = "false"
  }

  promote_froms = {
    canary = "staging"
  }

  shared_froms = {
    canary = "production"
  }

  promote_from  = "${lookup(local.promote_froms, terraform.workspace)}"
  auto_promote  = "${lookup(local.auto_promotes, terraform.workspace)}"
  min_count     = "${lookup(local.min_counts, terraform.workspace)}"
  max_count     = "${lookup(local.max_counts, terraform.workspace)}"
  desired_count = "${lookup(local.desired_counts, terraform.workspace)}"
  shared_from   = "${lookup(local.shared_froms, terraform.workspace)}"
  profile       = "${lookup(local.profiles, terraform.workspace)}"
}

provider "aws" {
  profile             = "${local.profile}"
  allowed_account_ids = ["${lookup(local.account_ids, terraform.workspace)}"]
  region              = "${local.region}"
}

terraform {
  backend "s3" {
    bucket  = "twitch-rbac-prod"
    key     = "devrel/helloworld-shared-us-west-2.tfstate"
    region  = "us-west-2"
    profile = "twitch-rbac-prod"
  }
}

provider "consul" {
  address    = "consul.internal.justin.tv"
  datacenter = "us-west2"
}

module "account" {
  source = "../../modules/account"
}

data "terraform_remote_state" "account_core" {
  backend     = "s3"
  environment = "${terraform.workspace}"

  config {
    bucket  = "${local.profile}"
    key     = "tfstate/devrel/vienna/terraform/account/terraform.tfstate"
    region  = "us-west-2"
    profile = "${local.profile}"
  }
}

data "terraform_remote_state" "region_core" {
  backend     = "s3"
  environment = "${terraform.workspace}"

  config {
    bucket  = "${local.profile}"
    key     = "tfstate/devrel/vienna/terraform/account/terraform.tfstate"
    region  = "us-west-2"
    profile = "${local.profile}"
  }
}

data "terraform_remote_state" "shared_data" {
  backend     = "s3"
  environment = "${local.shared_from}"

  config {
    bucket  = "twitch-rbac-prod"
    key     = "devrel/helloworld-us-west-2.tfstate"
    region  = "us-west-2"
    profile = "twitch-rbac-prod"
  }
}

module "permissions" {
  source      = "../../modules/helloworld/permissions"
  environment = "${terraform.workspace}"
  items_table = "${data.terraform_remote_state.shared_data.items_table}"
  iam_id      = "${module.helloworld.iam_id}"
}

module "helloworld" {
  source           = "../../modules/helloworld/cluster"
  environment      = "${terraform.workspace}"
  target_group_arn = "${data.terraform_remote_state.shared_data.target_group_arn}"
  cluster_name     = "${data.terraform_remote_state.region_core.common_cluster_name}"

  min_size                  = "${local.min_count}"
  desired_count             = "${local.desired_count}"
  max_size                  = "${local.max_count}"
  service_iam_role          = "${data.terraform_remote_state.account_core.service_iam_role}"
  task_autoscale_iam_role   = "${data.terraform_remote_state.account_core.task_autoscale_iam_role}"
  profile                   = "${local.profile}"
  promote_from              = "${local.promote_from}"
  auto_promote              = "${local.auto_promote}"
  deploy_aws_role           = "${data.terraform_remote_state.account_core.build_role}"
  container_loggroup_region = "${data.terraform_remote_state.region_core.container_loggroup_region}"
  container_loggroup        = "${data.terraform_remote_state.region_core.container_loggroup}"
  aws_creds                 = "${module.account.jenkins_build_secret[terraform.workspace]}"
}
