variable "vpc_id" {
  type = "map"

  default = {
    production.us-west-2  = "vpc-dd68e2ba"
    canary.us-west-2      = "vpc-dd68e2ba"
    staging.us-west-2     = "vpc-5855df3f"
    integration.us-west-2 = "vpc-5855df3f"
  }
}

output "vpc_id" {
  value = "${var.vpc_id}"
}

variable "private_subnets" {
  type = "map"

  default = {
    production.us-west-2  = ["subnet-dadf71bd", "subnet-c28a4a8b", "subnet-20bd9278"]
    canary.us-west-2      = ["subnet-dadf71bd", "subnet-c28a4a8b", "subnet-20bd9278"]
    staging.us-west-2     = ["subnet-3cccc474", "subnet-85de70e2", "subnet-e6be91be"]
    integration.us-west-2 = ["subnet-3cccc474", "subnet-85de70e2", "subnet-e6be91be"]
  }
}

output "private_subnets" {
  value = "${var.private_subnets}"
}

variable "public_subnets" {
  type = "map"

  default = {
    production.us-west-2  = ["subnet-5562f12c", "subnet-ad0db0e6", "subnet-b1d5bfeb"]
    canary.us-west-2      = ["subnet-5562f12c", "subnet-ad0db0e6", "subnet-b1d5bfeb"]
    staging.us-west-2     = ["subnet-39cec671", "subnet-85de70e2", "subnet-23bf6079"]
    integration.us-west-2 = ["subnet-39cec671", "subnet-85de70e2", "subnet-23bf6079"]
  }
}

output "public_subnets" {
  value = "${var.public_subnets}"
}

variable "sg_id" {
  type = "map"

  default = {
    production.us-west-2  = "sg-270c9c5f"
    canary.us-west-2      = "sg-270c9c5f"
    staging.us-west-2     = "sg-a70b9bdf"
    integration.us-west-2 = "sg-a70b9bdf"
  }
}

output "sg_id" {
  value = "${var.sg_id}"
}

variable jenkins_build_secret {
    type = "map"

    default = {
        production  = "twitch-rbac-prod-file"
        canary      = "twitch-rbac-prod-file"
        staging     = "twitch-rbac-dev-file"
        integration = "twitch-rbac-dev-file"
    }
}

output jenkins_build_secret {
    value = "${var.jenkins_build_secret}"
}
