variable "environment" {}

variable "name" {
  default = "helloworld"
}

variable iam_id {}

variable items_table {}

resource "aws_iam_role_policy" "policy" {
  name = "${var.name}_${var.environment}_dynamo_policy"
  role = "${var.iam_id}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "dynamodb:*"
      ],
      "Resource": [
        "${var.items_table}"
      ]
    }
  ]
}
EOF
}
