// +build integration

package consulconf

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"testing"
	"time"

	"github.com/hashicorp/consul/api"
	. "github.com/smartystreets/goconvey/convey"
)

type config struct {
	ConsulAddress string
	Prefix        string
	Datacenter    string

	Key         string
	EndingValue string
}

func TestIntegrationConsulconf(t *testing.T) {
	Convey("With config", t, func() {
		content, err := ioutil.ReadFile(".consulconf_integration.json")
		So(err, ShouldBeNil)
		var c config
		So(json.Unmarshal(content, &c), ShouldBeNil)
		config := api.DefaultConfig()
		config.Address = c.ConsulAddress
		config.Datacenter = c.Datacenter

		client, err := api.NewClient(config)
		So(err, ShouldBeNil)

		_, err = client.Agent().NodeName()
		So(err, ShouldBeNil)

		s := Consulconf{
			KV:     client.KV(),
			Prefix: c.Prefix,
		}
		ret, err := s.Get(c.Key)
		So(err, ShouldBeNil)
		So(ret, ShouldNotBeNil)
		So(string(ret), ShouldEqual, c.EndingValue)

		if testing.Short() {
			return
		}

		So(s.Watch(c.Key, func(key string) {
			newVal, err := s.Get(key)
			So(err, ShouldBeNil)
			So(newVal, ShouldNotEqual, c.EndingValue)
			t.Logf("Update on key %s is now %s", key, newVal)
		}), ShouldBeNil)

		for i := 0; i < 30; i++ {
			fmt.Printf("On sleep %d\n", i)
			t.Logf("On sleep %d", i)
			time.Sleep(time.Second)
			s.Refresh()
		}
	})
}
