import { StreamWriter, writeCSV } from './csv-writer';
import db from './db';
import { getCompanies, getMainDomain, getResources } from './utils';

(async () => {
  try {
    await db.connect();

    const domain = await getMainDomain();
    const companies = await getCompanies();
    const games = await getResources('game');

    const csvPath = './permissions.csv';

    writeCSV(
      {
        csvPath,
        fields: ['name', 'description', 'domain_id'],
        table: 'permissions',
      },
      (stream: StreamWriter) => {
        function createPermission(id: string, desc: string, domain: string) {
          stream.write([id, desc, domain]);
        }

        for (const company of companies) {
          createPermission(`${company.identifier}::editCompanyInfo`, 'Allows a user to edit company info', domain.id);
          createPermission(
            `${company.identifier}::showCompanyMembers`,
            'Allows a user to see company members',
            domain.id,
          );
          createPermission(
            `${company.identifier}::addUser`,
            'Allows a user to add another user to a company',
            domain.id,
          );
          createPermission(
            `${company.identifier}::removeUser`,
            'Allows a user to remove another user from a company',
            domain.id,
          );
          createPermission(
            `${company.identifier}::assignPermissions`,
            'Allows a user to assign company permissions',
            domain.id,
          );
          createPermission(
            `${company.identifier}::games::add`,
            'Allows a user to add a game to the company',
            domain.id,
          );
          createPermission(
            `${company.identifier}::drops::view`,
            'Allows a user to view the companies drops',
            domain.id,
          );
          createPermission(`${company.identifier}::drops::create`, 'Allows a user to create a new drop', domain.id);
          createPermission(`${company.identifier}::drops::manage`, 'Allows a user to edit an existing drop', domain.id);
          createPermission(
            `${company.identifier}::drops::delete`,
            'Allows a user to delete an existing drop',
            domain.id,
          );
          createPermission(
            `${company.identifier}::insights-1pager::view`,
            'Allows a user to view game insights 1 pager',
            domain.id,
          );
        }

        for (const game of games) {
          createPermission(
            `${game.identifier}::boxart::edit`,
            `Allows a user to edit boxart of ${game.description}`,
            domain.id,
          );
          createPermission(
            `${game.identifier}::analytics::view`,
            `Allows a user to view the analytics for ${game.description}`,
            domain.id,
          );
        }
      },
      () => {
        process.exit();
      },
    );
  } catch (err) {
    console.log(`fatal: ${err}`);
  }
})();
