import { StreamWriter, writeCSV } from './csv-writer';
import db from './db';
import { getCompanies, getMainDomain } from './utils';

(async () => {
  await db.connect();

  const domain = await getMainDomain();
  const companies = await getCompanies();

  const roles = companies.map(comp => [
    {
      domain_id: domain.id,
      name: `${comp.identifier}::admin`,
      description: 'Administrator',
    },
    {
      domain_id: domain.id,
      name: `${comp.identifier}::manager`,
      description: 'Manager',
    },
    {
      domain_id: domain.id,
      name: `${comp.identifier}::developer`,
      description: 'Developer',
    },
    {
      domain_id: domain.id,
      name: `${comp.identifier}::marketer`,
      description: 'Marketer',
    },
  ]);

  writeCSV(
    {
      csvPath: './roles.csv',
      fields: ['name', 'description', 'domain_id'],
      table: 'roles',
    },
    (stream: StreamWriter) => {
      for (const companyRoles of roles) {
        for (const role of companyRoles) {
          stream.write([role.name, role.description, role.domain_id]);
        }
      }
    },
    () => {
      process.exit();
    },
  );
})();
