import { readFileSync } from 'fs';
import * as Papa from 'papaparse';
import { resolve } from 'path';
import { GameMapping } from './csv-read';
import { Resource } from './utils';

export function loadGamesByGameID() {
  const gamesExportPath = resolve(__dirname, '..', 'data/GamesExport.csv');
  const gamesBuffer = readFileSync(gamesExportPath);
  const gamesResult = Papa.parse(gamesBuffer.toString(), {
    header: true,
  });
  const games: Resource[] = gamesResult.data;

  const gamesByGameID = {};
  for (const game of games) {
    if (!game || !game.external_id || !game.identifier) {
      console.log('not game', game);
      continue;
    }

    gamesByGameID[game.external_id] = game;
  }

  return gamesByGameID;
}

export interface GameMapping {
  game_id: string;
  company: string;
}

export function loadGamesMappings(): GameMapping[] {
  const gameCompanyMappingPath = resolve(__dirname, '..', 'data/GameByCompany.csv');
  const companyBuffer = readFileSync(gameCompanyMappingPath);
  const companyResult = Papa.parse(companyBuffer.toString(), {
    header: true,
  });
  console.log('game mapping length', companyResult.data.length);
  return companyResult.data as GameMapping[];
}

export interface UserCompanyMapping {
  twitch_id: string;
  company_id: string;
  email: string;
  role: string;
}

export function loadUserCompanyMappings() {
  const developerRolesPath = resolve(__dirname, '..', 'data/DeveloperByCompanies.csv');
  const developerBuffer = readFileSync(developerRolesPath);
  const result = Papa.parse(developerBuffer.toString(), {
    header: true,
  });
  const developerMappings: UserCompanyMapping[] = result.data;
  return developerMappings;
}
