import { resolve } from 'path';
import { QueryConfig } from 'pg';
import db from './db';

(async () => {
  try {
    await db.connect();
    const csvPath = resolve(__dirname, '..', 'data', 'CompanyExport.csv');
    const query: QueryConfig = {
      text: `
      COPY companies(id,company_name,url,type,vhs_contract_signed,campaigns_enabled,identifier,curse_company_id,created_at)
      FROM '${csvPath}'
      WITH (FORMAT csv)
      `,
    };

    await db.query(query);
  } catch (e) {
    console.log('ERR');
    console.log(e);
  }

  process.exit();
})();
