import { resolve } from 'path';
import { QueryConfig } from 'pg';
import db from './db';

(async () => {
  try {
    await db.connect();
    const csvPath = resolve(__dirname, '..', 'data', 'GamesExport.csv');
    const query: QueryConfig = {
      text: `
      copy resource_types
      FROM '${csvPath}'
      WITH (FORMAT csv)
      `,
    };

    await db.query(query);
  } catch (e) {
    console.log('ERR');
    console.log(e);
  }

  process.exit();
})();
