import { resolve } from 'path';
import { QueryConfig } from 'pg';
import db from './db';

(async () => {
  try {
    await db.connect();
    const csvPath = resolve(__dirname, '..', 'data', 'DeveloperExport.csv');
    const query: QueryConfig = {
      text: `
      COPY twitch_developers (twitch_id,first_name,last_name,dev_title,dev_email,created_at,modified_at,user_id)
      FROM '${csvPath}'
      WITH (FORMAT csv)
      `,
    };

    await db.query(query);
  } catch (e) {
    console.log('ERR');
    console.log(e);
  }

  process.exit();
})();
