--
-- PostgreSQL database dump
--

-- Dumped from database version 10.3
-- Dumped by pg_dump version 10.3

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


--
-- Name: uuid-ossp; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS "uuid-ossp" WITH SCHEMA public;


--
-- Name: EXTENSION "uuid-ossp"; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION "uuid-ossp" IS 'generate universally unique identifiers (UUIDs)';

--
-- Name: pg_trgm; Type: EXTENSION; Schema: -; Owner:
--

CREATE EXTENSION IF NOT EXISTS pg_trgm WITH SCHEMA public;


--
-- Name: EXTENSION pg_trgm; Type: COMMENT; Schema: -; Owner:
--

COMMENT ON EXTENSION pg_trgm IS 'text similarity measurement and index searching based on trigrams';


SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: action_histories; Type: TABLE; Schema: public; Owner: rbac
--

CREATE TABLE public.action_histories (
    id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    action character varying(250),
    created_at timestamp without time zone,
    user_id uuid
);


ALTER TABLE public.action_histories OWNER TO rbac;

--
-- Name: companies; Type: TABLE; Schema: public; Owner: rbac
--

CREATE TABLE public.companies (
    id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    company_name character varying(250),
    url character varying(150),
    type integer,
    vhs_contract_signed boolean,
    campaigns_enabled boolean,
    identifier character varying(250),
    curse_company_id integer,
    created_at timestamp without time zone,
    legacy boolean DEFAULT false
);


ALTER TABLE public.companies OWNER TO rbac;

--
-- Name: company_applications; Type: TABLE; Schema: public; Owner: rbac
--

CREATE TABLE public.company_applications (
    id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    company_name character varying(250),
    company_website character varying(150),
    company_type integer,
    games character varying(100),
    industry character varying(50),
    company_size character varying(50),
    city character varying(50),
    state character varying(50),
    country character varying(50),
    contact_first_name character varying(50),
    contact_last_name character varying(50),
    contact_title character varying(50),
    contact_email character varying(50),
    product_interest character varying(500),
    join_reason character varying(500),
    twitch_id character varying(50),
    status integer,
    created_at timestamp without time zone,
    salesforce_id character varying(50)
);


ALTER TABLE public.company_applications OWNER TO rbac;

--
-- Name: domains; Type: TABLE; Schema: public; Owner: rbac
--

CREATE TABLE public.domains (
    id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    name character varying(50),
    description text
);


ALTER TABLE public.domains OWNER TO rbac;

--
-- Name: game_applications; Type: TABLE; Schema: public; Owner: rbac
--

CREATE TABLE public.game_applications (
    id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    game_id integer,
    created_at timestamp without time zone,
    company_id uuid
);


ALTER TABLE public.game_applications OWNER TO rbac;

--
-- Name: permission_identifiers; Type: TABLE; Schema: public; Owner: rbac
--

CREATE TABLE public.permission_identifiers (
    identifier character varying(250) NOT NULL,
    description text
);


ALTER TABLE public.permission_identifiers OWNER TO rbac;

--
-- Name: permissions; Type: TABLE; Schema: public; Owner: rbac
--

CREATE TABLE public.permissions (
    id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    name character varying(250),
    description text,
    domain_id uuid
);


ALTER TABLE public.permissions OWNER TO rbac;

--
-- Name: rbac_clients; Type: TABLE; Schema: public; Owner: rbac
--

CREATE TABLE public.rbac_clients (
    client_id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    client_secret character varying(50),
    domain_id uuid DEFAULT public.uuid_generate_v4()
);


ALTER TABLE public.rbac_clients OWNER TO rbac;

--
-- Name: resource_types; Type: TABLE; Schema: public; Owner: rbac
--

CREATE TABLE public.resource_types (
    identifier character varying(250) NOT NULL,
    description text,
    external_id character varying(50),
    type character varying(50)
);


ALTER TABLE public.resource_types OWNER TO rbac;

--
-- Name: role_identifiers; Type: TABLE; Schema: public; Owner: rbac
--

CREATE TABLE public.role_identifiers (
    identifier character varying(250) NOT NULL,
    description text
);


ALTER TABLE public.role_identifiers OWNER TO rbac;

--
-- Name: role_permissions; Type: TABLE; Schema: public; Owner: rbac
--

CREATE TABLE public.role_permissions (
    role_id uuid,
    permission_id uuid,
    recursive_role_id uuid
);


ALTER TABLE public.role_permissions OWNER TO rbac;

--
-- Name: role_resources; Type: TABLE; Schema: public; Owner: rbac
--

CREATE TABLE public.role_resources (
    resource character varying(250),
    role_id uuid
);


ALTER TABLE public.role_resources OWNER TO rbac;

--
-- Name: roles; Type: TABLE; Schema: public; Owner: rbac
--

CREATE TABLE public.roles (
    id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    name character varying(250),
    description text,
    domain_id uuid
);


ALTER TABLE public.roles OWNER TO rbac;

--
-- Name: twitch_developers; Type: TABLE; Schema: public; Owner: rbac
--

CREATE TABLE public.twitch_developers (
    user_id uuid DEFAULT public.uuid_generate_v4() NOT NULL,
    twitch_id character varying(50),
    first_name character varying(64),
    last_name character varying(64),
    dev_title character varying(64),
    dev_email character varying(64),
    created_at timestamp without time zone,
    modified_at timestamp without time zone
);


ALTER TABLE public.twitch_developers OWNER TO rbac;

--
-- Name: user_roles; Type: TABLE; Schema: public; Owner: rbac
--

CREATE TABLE public.user_roles (
    user_id uuid,
    role_id uuid
);


ALTER TABLE public.user_roles OWNER TO rbac;

--
-- Name: action_histories action_histories_pkey; Type: CONSTRAINT; Schema: public; Owner: rbac
--

ALTER TABLE ONLY public.action_histories
    ADD CONSTRAINT action_histories_pkey PRIMARY KEY (id);


--
-- Name: companies companies_pkey; Type: CONSTRAINT; Schema: public; Owner: rbac
--

ALTER TABLE ONLY public.companies
    ADD CONSTRAINT companies_pkey PRIMARY KEY (id);


--
-- Name: company_applications company_applications_pkey; Type: CONSTRAINT; Schema: public; Owner: rbac
--

ALTER TABLE ONLY public.company_applications
    ADD CONSTRAINT company_applications_pkey PRIMARY KEY (id);


--
-- Name: domains domains_pkey; Type: CONSTRAINT; Schema: public; Owner: rbac
--

ALTER TABLE ONLY public.domains
    ADD CONSTRAINT domains_pkey PRIMARY KEY (id);


--
-- Name: game_applications game_applications_pkey; Type: CONSTRAINT; Schema: public; Owner: rbac
--

ALTER TABLE ONLY public.game_applications
    ADD CONSTRAINT game_applications_pkey PRIMARY KEY (id);


--
-- Name: permissions permissions_pkey; Type: CONSTRAINT; Schema: public; Owner: rbac
--

ALTER TABLE ONLY public.permissions
    ADD CONSTRAINT permissions_pkey PRIMARY KEY (id);


--
-- Name: rbac_clients rbac_clients_pkey; Type: CONSTRAINT; Schema: public; Owner: rbac
--

ALTER TABLE ONLY public.rbac_clients
    ADD CONSTRAINT rbac_clients_pkey PRIMARY KEY (client_id);


--
-- Name: roles roles_pkey; Type: CONSTRAINT; Schema: public; Owner: rbac
--

ALTER TABLE ONLY public.roles
    ADD CONSTRAINT roles_pkey PRIMARY KEY (id);


--
-- Name: twitch_developers twitch_developer_pkey; Type: CONSTRAINT; Schema: public; Owner: rbac
--

ALTER TABLE ONLY public.twitch_developers
    ADD CONSTRAINT twitch_developer_pkey PRIMARY KEY (user_id);


--
-- Name: game_applications FK_game_applications_game; Type: FK CONSTRAINT; Schema: public; Owner: rbac
--

ALTER TABLE ONLY public.game_applications
    ADD CONSTRAINT "FK_game_applications_game" FOREIGN KEY (company_id) REFERENCES public.companies(id);


--
-- Name: permissions FK_permissions_domain; Type: FK CONSTRAINT; Schema: public; Owner: rbac
--

ALTER TABLE ONLY public.permissions
    ADD CONSTRAINT "FK_permissions_domain" FOREIGN KEY (domain_id) REFERENCES public.domains(id);


--
-- Name: rbac_clients FK_rbac_clients_domain; Type: FK CONSTRAINT; Schema: public; Owner: rbac
--

ALTER TABLE ONLY public.rbac_clients
    ADD CONSTRAINT "FK_rbac_clients_domain" FOREIGN KEY (domain_id) REFERENCES public.domains(id);


--
-- Name: role_permissions FK_role_permissions_permission; Type: FK CONSTRAINT; Schema: public; Owner: rbac
--

ALTER TABLE ONLY public.role_permissions
    ADD CONSTRAINT "FK_role_permissions_permission" FOREIGN KEY (permission_id) REFERENCES public.permissions(id);


--
-- Name: role_permissions FK_role_permissions_recursive_role; Type: FK CONSTRAINT; Schema: public; Owner: rbac
--

ALTER TABLE ONLY public.role_permissions
    ADD CONSTRAINT "FK_role_permissions_recursive_role" FOREIGN KEY (recursive_role_id) REFERENCES public.roles(id);


--
-- Name: role_permissions FK_role_permissions_role; Type: FK CONSTRAINT; Schema: public; Owner: rbac
--

ALTER TABLE ONLY public.role_permissions
    ADD CONSTRAINT "FK_role_permissions_role" FOREIGN KEY (role_id) REFERENCES public.roles(id);


--
-- Name: role_resources FK_role_resource_role; Type: FK CONSTRAINT; Schema: public; Owner: rbac
--

ALTER TABLE ONLY public.role_resources
    ADD CONSTRAINT "FK_role_resource_role" FOREIGN KEY (role_id) REFERENCES public.roles(id);


--
-- Name: roles FK_roles_domain; Type: FK CONSTRAINT; Schema: public; Owner: rbac
--

ALTER TABLE ONLY public.roles
    ADD CONSTRAINT "FK_roles_domain" FOREIGN KEY (domain_id) REFERENCES public.domains(id);


--
-- Name: user_roles FK_user_roles; Type: FK CONSTRAINT; Schema: public; Owner: rbac
--

ALTER TABLE ONLY public.user_roles
    ADD CONSTRAINT "FK_user_roles" FOREIGN KEY (role_id) REFERENCES public.roles(id);


--
-- Name: user_roles FK_user_roles_user_id; Type: FK CONSTRAINT; Schema: public; Owner: rbac
--

ALTER TABLE ONLY public.user_roles
    ADD CONSTRAINT "FK_user_roles_user_id" FOREIGN KEY (user_id) REFERENCES public.twitch_developers(user_id);


--
-- PostgreSQL database dump complete
--

