# Vienna

Vienna is an internal static site for RBAC admin management and company application reviews.

## Environments

 * Production: https://devsite-vienna.xarth.tv
 * Staging: https://staging.devsite-vienna.xarth.tv (Your twitch account in staging is the same as in production. If you need a new account for testing, you have to create the account in production and wait 24 hours until users-service re-populates staging data).
 * Local: http://localhost:3000 (after launching with `yarn start`).

Configuration for each environment is in `src/config`.

## Development

### Setup dev environment

Similar to Twilight: https://git-aws.internal.justin.tv/pages/twilight/twilight-docs/#setting-up-your-dev-environment

 * Install Node LTS 8.11.x: `brew install node@8`
 * Install protoc: `brew install protobuf`. Used to generate a typescript client for RBAC.
 * Install Yarn 1.10.x: `brew install yarn --without-node`, although that will install the latest version. You could do `brew switch yarn 1.10.1` to ensure the same version, or even better, update this REAMDE file with latest version and tell everyone in the team to update.
 * Install dependencies: `yarn install`. Make sure to be on the Twitch VPN to allow accessing npm.internal.justin.tv.

Development scripts are defined in the [package.json file](package.json), you can list scripts with `yarn run`.
Run scripts with `yarn run <script>` or the shorter form `yarn <script>`:

```sh
yarn install # if you see Can not find module error, probably someone else added a new dependency
yarn lint
yarn start       # runs locally, configured to use rbac staging
yarn start:local # runs locally, configured to use rbac local, rbac should be running in localhost
yarn start:prod  # runs locally, using rbac production
yarn build:production # make a production build (same configuration) that you can open in your browser
```

#### RBAC Twirp Client

The client to use the RBAC API is automatically generated. But since Twirp clients in TypeScript are not fully supported yet, you can expect some quirks here and there. For example, the API is used with JSON instead of Protobuf, and missing values sometimes return undefined instead of the zero-value. YMMV

When the proto file is updated in RBAC, you can re-generate the TypeScript client here with `make rbac_twirp_gen`:

### Infra and Terraform

See [terraform/README.md](terraform/README.md)


## Grafana Dashboard

 * Production ELB metrics: https://grafana.internal.justin.tv/d/YPBbR3Lmk/vienna?orgId=1&from=now-7d&to=now&panelId=4&tab=display


## Deploy

 * Deploy to staging: Run `make deploy_staging`. It will force-push your branch into the origin `staging` branch. The deploy is handled by the [Jenkins pipeline staging job](https://jenkins.internal.justin.tv/job/devrel/job/vienna/job/staging/).
 * Deploy to production: Make a PR, get someone to approve it and merge on Github. The deploy is handled by the [Jenkins pipeline master job](https://jenkins.internal.justin.tv/job/devrel/job/vienna/job/master/).
