import { RBAC } from 'vienna/common/clients/rbacClient';

// Load all available roles from the backend: "Owner", "Manager", etc.
export const fetchAllRoles = async (): Promise<string[]> => {
  const {
    error,
    data: { roles },
  } = await RBAC.listAllRoles({});
  if (error) {
    return [];
  }
  return roles;
};
