import { createTwirpRequest, Fetch, TwirpError, TwirpErrorJSON, TwirpResponse } from './twirp';

export interface Empty {}
interface EmptyJSON {}

const EmptyToJSON = (m: Empty): EmptyJSON => {
  return {};
};

const JSONToEmpty = (m: Empty | EmptyJSON): Empty => {
  if (!m) {
    return {};
  }

  return {};
};

export interface Id {
  id: string;
}
interface IdJSON {
  id: string;
}

const IdToJSON = (m: Id): IdJSON => {
  return {
    id: m.id,
  };
};

export interface TransferExtensionRequest {
  companyId: string;
  extensionId: string;
  billingManagerId: string;
}
interface TransferExtensionRequestJSON {
  company_id: string;
  extension_id: string;
  billing_manager_id: string;
}

const TransferExtensionRequestToJSON = (m: TransferExtensionRequest): TransferExtensionRequestJSON => {
  return {
    company_id: m.companyId,
    extension_id: m.extensionId,
    billing_manager_id: m.billingManagerId,
  };
};

export interface DetachExtensionRequest {
  companyId: string;
  extensionId: string;
  ownerId: string;
}
interface DetachExtensionRequestJSON {
  company_id: string;
  extension_id: string;
  owner_id: string;
}

const DetachExtensionRequestToJSON = (m: DetachExtensionRequest): DetachExtensionRequestJSON => {
  return {
    company_id: m.companyId,
    extension_id: m.extensionId,
    owner_id: m.ownerId,
  };
};

export interface SetStateInReviewRequest {
  userTwitchId: string;
  extensionId: string;
  extensionVersion: string;
  testChannel: string;
  notes: string;
}
interface SetStateInReviewRequestJSON {
  user_twitch_id: string;
  extension_id: string;
  extension_version: string;
  test_channel: string;
  notes: string;
}

const SetStateInReviewRequestToJSON = (m: SetStateInReviewRequest): SetStateInReviewRequestJSON => {
  return {
    user_twitch_id: m.userTwitchId,
    extension_id: m.extensionId,
    extension_version: m.extensionVersion,
    test_channel: m.testChannel,
    notes: m.notes,
  };
};

export interface GetLatestAuthorNotesRequest {
  authorTwitchId: string;
  extensionId: string;
}
interface GetLatestAuthorNotesRequestJSON {
  author_twitch_id: string;
  extension_id: string;
}

const GetLatestAuthorNotesRequestToJSON = (m: GetLatestAuthorNotesRequest): GetLatestAuthorNotesRequestJSON => {
  return {
    author_twitch_id: m.authorTwitchId,
    extension_id: m.extensionId,
  };
};

export interface GetLatestAuthorNotesResponse {
  authorTwitchId: string;
  extensionId: string;
  extensionVersion: string;
  reviewLogCreatedAt: string;
  authorNotes: string;
  authorChannel: string;
}
interface GetLatestAuthorNotesResponseJSON {
  author_twitch_id: string;
  extension_id: string;
  extension_version: string;
  review_log_created_at: string;
  author_notes: string;
  author_channel: string;
}

const JSONToGetLatestAuthorNotesResponse = (
  m: GetLatestAuthorNotesResponse | GetLatestAuthorNotesResponseJSON,
): GetLatestAuthorNotesResponse => {
  if (!m) {
    return {
      authorTwitchId: '',
      extensionId: '',
      extensionVersion: '',
      reviewLogCreatedAt: '',
      authorNotes: '',
      authorChannel: '',
    };
  }

  return {
    authorTwitchId:
      ((m as GetLatestAuthorNotesResponse).authorTwitchId
        ? (m as GetLatestAuthorNotesResponse).authorTwitchId
        : (m as GetLatestAuthorNotesResponseJSON).author_twitch_id) || '',
    extensionId:
      ((m as GetLatestAuthorNotesResponse).extensionId
        ? (m as GetLatestAuthorNotesResponse).extensionId
        : (m as GetLatestAuthorNotesResponseJSON).extension_id) || '',
    extensionVersion:
      ((m as GetLatestAuthorNotesResponse).extensionVersion
        ? (m as GetLatestAuthorNotesResponse).extensionVersion
        : (m as GetLatestAuthorNotesResponseJSON).extension_version) || '',
    reviewLogCreatedAt:
      ((m as GetLatestAuthorNotesResponse).reviewLogCreatedAt
        ? (m as GetLatestAuthorNotesResponse).reviewLogCreatedAt
        : (m as GetLatestAuthorNotesResponseJSON).review_log_created_at) || '',
    authorNotes:
      ((m as GetLatestAuthorNotesResponse).authorNotes
        ? (m as GetLatestAuthorNotesResponse).authorNotes
        : (m as GetLatestAuthorNotesResponseJSON).author_notes) || '',
    authorChannel:
      ((m as GetLatestAuthorNotesResponse).authorChannel
        ? (m as GetLatestAuthorNotesResponse).authorChannel
        : (m as GetLatestAuthorNotesResponseJSON).author_channel) || '',
  };
};

export interface SetStateReviewerRequest {
  extensionId: string;
  extensionVersion: string;
  reviewReasonCodes: string[];
  reviewReason: string;
}
interface SetStateReviewerRequestJSON {
  extension_id: string;
  extension_version: string;
  review_reason_codes: string[];
  review_reason: string;
}

const SetStateReviewerRequestToJSON = (m: SetStateReviewerRequest): SetStateReviewerRequestJSON => {
  return {
    extension_id: m.extensionId,
    extension_version: m.extensionVersion,
    review_reason_codes: m.reviewReasonCodes,
    review_reason: m.reviewReason,
  };
};

export interface ExtensionVersionID {
  id: string;
  version: string;
}
interface ExtensionVersionIDJSON {
  id: string;
  version: string;
}

const ExtensionVersionIDToJSON = (m: ExtensionVersionID): ExtensionVersionIDJSON => {
  return {
    id: m.id,
    version: m.version,
  };
};

export interface Extension {
  id: string;
  version: string;
  name: string;
  description: string;
  summary: string;
  state: string;
  authorName: string;
  transitionLogs: ExtensionReviewLog[];
}
interface ExtensionJSON {
  id: string;
  version: string;
  name: string;
  description: string;
  summary: string;
  state: string;
  author_name: string;
  transition_logs: ExtensionReviewLogJSON[];
}

const JSONToExtension = (m: Extension | ExtensionJSON): Extension => {
  if (!m) {
    return {
      id: '',
      version: '',
      name: '',
      description: '',
      summary: '',
      state: '',
      authorName: '',
      transitionLogs: [],
    };
  }

  return {
    id: m.id || '',
    version: m.version || '',
    name: m.name || '',
    description: m.description || '',
    summary: m.summary || '',
    state: m.state || '',
    authorName: ((m as Extension).authorName ? (m as Extension).authorName : (m as ExtensionJSON).author_name) || '',
    transitionLogs: (
      (((m as Extension).transitionLogs ? (m as Extension).transitionLogs : (m as ExtensionJSON).transition_logs) as (
        | ExtensionReviewLog
        | ExtensionReviewLogJSON)[]) || []
    ).map(JSONToExtensionReviewLog),
  };
};

export interface ExtensionReviewLog {
  createdAt: string;
  state: string;
  authorTwitchId: string;
  authorNotes: string;
  authorChannel: string;
  extensionId: string;
  extensionVersion: string;
  reviewerTwitchId: string;
  reviewReasonCodes: string[];
  reviewReason: string;
  salesforceCaseId: string;
}
interface ExtensionReviewLogJSON {
  created_at: string;
  state: string;
  author_twitch_id: string;
  author_notes: string;
  author_channel: string;
  extension_id: string;
  extension_version: string;
  reviewer_twitch_id: string;
  review_reason_codes: string[];
  review_reason: string;
  salesforce_case_id: string;
}

const JSONToExtensionReviewLog = (m: ExtensionReviewLog | ExtensionReviewLogJSON): ExtensionReviewLog => {
  if (!m) {
    return {
      createdAt: '',
      state: '',
      authorTwitchId: '',
      authorNotes: '',
      authorChannel: '',
      extensionId: '',
      extensionVersion: '',
      reviewerTwitchId: '',
      reviewReasonCodes: [],
      reviewReason: '',
      salesforceCaseId: '',
    };
  }

  return {
    createdAt:
      ((m as ExtensionReviewLog).createdAt
        ? (m as ExtensionReviewLog).createdAt
        : (m as ExtensionReviewLogJSON).created_at) || '',
    state: m.state || '',
    authorTwitchId:
      ((m as ExtensionReviewLog).authorTwitchId
        ? (m as ExtensionReviewLog).authorTwitchId
        : (m as ExtensionReviewLogJSON).author_twitch_id) || '',
    authorNotes:
      ((m as ExtensionReviewLog).authorNotes
        ? (m as ExtensionReviewLog).authorNotes
        : (m as ExtensionReviewLogJSON).author_notes) || '',
    authorChannel:
      ((m as ExtensionReviewLog).authorChannel
        ? (m as ExtensionReviewLog).authorChannel
        : (m as ExtensionReviewLogJSON).author_channel) || '',
    extensionId:
      ((m as ExtensionReviewLog).extensionId
        ? (m as ExtensionReviewLog).extensionId
        : (m as ExtensionReviewLogJSON).extension_id) || '',
    extensionVersion:
      ((m as ExtensionReviewLog).extensionVersion
        ? (m as ExtensionReviewLog).extensionVersion
        : (m as ExtensionReviewLogJSON).extension_version) || '',
    reviewerTwitchId:
      ((m as ExtensionReviewLog).reviewerTwitchId
        ? (m as ExtensionReviewLog).reviewerTwitchId
        : (m as ExtensionReviewLogJSON).reviewer_twitch_id) || '',
    reviewReasonCodes: (m as ExtensionReviewLog).reviewReasonCodes
      ? (m as ExtensionReviewLog).reviewReasonCodes
      : (m as ExtensionReviewLogJSON).review_reason_codes,
    reviewReason:
      ((m as ExtensionReviewLog).reviewReason
        ? (m as ExtensionReviewLog).reviewReason
        : (m as ExtensionReviewLogJSON).review_reason) || '',
    salesforceCaseId:
      ((m as ExtensionReviewLog).salesforceCaseId
        ? (m as ExtensionReviewLog).salesforceCaseId
        : (m as ExtensionReviewLogJSON).salesforce_case_id) || '',
  };
};

export interface ListEntityActionHistoriesRequest {
  entityId: string;
  entityType: string;
}
interface ListEntityActionHistoriesRequestJSON {
  entity_id: string;
  entity_type: string;
}

const ListEntityActionHistoriesRequestToJSON = (
  m: ListEntityActionHistoriesRequest,
): ListEntityActionHistoriesRequestJSON => {
  return {
    entity_id: m.entityId,
    entity_type: m.entityType,
  };
};

export interface ListActionHistoriesRequest {
  companyId: string;
  entityId: string;
  entityType: string;
  limit: number;
  offset: number;
}
interface ListActionHistoriesRequestJSON {
  company_id: string;
  entity_id: string;
  entity_type: string;
  limit: number;
  offset: number;
}

const ListActionHistoriesRequestToJSON = (m: ListActionHistoriesRequest): ListActionHistoriesRequestJSON => {
  return {
    company_id: m.companyId,
    entity_id: m.entityId,
    entity_type: m.entityType,
    limit: m.limit,
    offset: m.offset,
  };
};

export interface ListActionHistoriesResponse {
  actionhistories: ActionHistory[];
  total: number;
}
interface ListActionHistoriesResponseJSON {
  actionHistories: ActionHistoryJSON[];
  total: number;
}

const JSONToListActionHistoriesResponse = (
  m: ListActionHistoriesResponse | ListActionHistoriesResponseJSON,
): ListActionHistoriesResponse => {
  if (!m) {
    return {
      actionhistories: [],
      total: 0,
    };
  }

  return {
    actionhistories: (
      (((m as ListActionHistoriesResponse).actionhistories
        ? (m as ListActionHistoriesResponse).actionhistories
        : (m as ListActionHistoriesResponseJSON).actionHistories) as (ActionHistory | ActionHistoryJSON)[]) || []
    ).map(JSONToActionHistory),
    total: m.total || 0,
  };
};

export interface ActionHistory {
  id: string;
  action: string;
  userTwitchId: string;
  createdat: string;
  entityId: string;
  entityType: string;
  companyId: string;
}
interface ActionHistoryJSON {
  id: string;
  action: string;
  user_twitch_id: string;
  createdAt: string;
  entity_id: string;
  entity_type: string;
  company_id: string;
}

const JSONToActionHistory = (m: ActionHistory | ActionHistoryJSON): ActionHistory => {
  if (!m) {
    return {
      id: '',
      action: '',
      userTwitchId: '',
      createdat: '',
      entityId: '',
      entityType: '',
      companyId: '',
    };
  }

  return {
    id: m.id || '',
    action: m.action || '',
    userTwitchId:
      ((m as ActionHistory).userTwitchId
        ? (m as ActionHistory).userTwitchId
        : (m as ActionHistoryJSON).user_twitch_id) || '',
    createdat:
      ((m as ActionHistory).createdat ? (m as ActionHistory).createdat : (m as ActionHistoryJSON).createdAt) || '',
    entityId:
      ((m as ActionHistory).entityId ? (m as ActionHistory).entityId : (m as ActionHistoryJSON).entity_id) || '',
    entityType:
      ((m as ActionHistory).entityType ? (m as ActionHistory).entityType : (m as ActionHistoryJSON).entity_type) || '',
    companyId:
      ((m as ActionHistory).companyId ? (m as ActionHistory).companyId : (m as ActionHistoryJSON).company_id) || '',
  };
};

export interface Company {
  id: string;
  companyname: string;
  url: string;
  type: number;
  vhsContractsigned: boolean;
  campaignsenabled: boolean;
  identifier: string;
  cursecompanyId: number;
  createdat: string;
  legacy: boolean;
}
interface CompanyJSON {
  id: string;
  companyName: string;
  url: string;
  type: number;
  vhs_contractSigned: boolean;
  campaignsEnabled: boolean;
  identifier: string;
  curseCompany_id: number;
  createdAt: string;
  legacy: boolean;
}

const JSONToCompany = (m: Company | CompanyJSON): Company => {
  if (!m) {
    return {
      id: '',
      companyname: '',
      url: '',
      type: 0,
      vhsContractsigned: false,
      campaignsenabled: false,
      identifier: '',
      cursecompanyId: 0,
      createdat: '',
      legacy: false,
    };
  }

  return {
    id: m.id || '',
    companyname: ((m as Company).companyname ? (m as Company).companyname : (m as CompanyJSON).companyName) || '',
    url: m.url || '',
    type: m.type || 0,
    vhsContractsigned:
      ((m as Company).vhsContractsigned ? (m as Company).vhsContractsigned : (m as CompanyJSON).vhs_contractSigned) ||
      false,
    campaignsenabled:
      ((m as Company).campaignsenabled ? (m as Company).campaignsenabled : (m as CompanyJSON).campaignsEnabled) ||
      false,
    identifier: m.identifier || '',
    cursecompanyId:
      ((m as Company).cursecompanyId ? (m as Company).cursecompanyId : (m as CompanyJSON).curseCompany_id) || 0,
    createdat: ((m as Company).createdat ? (m as Company).createdat : (m as CompanyJSON).createdAt) || '',
    legacy: m.legacy || false,
  };
};

export interface DeleteCompanyRequest {
  id: string;
}
interface DeleteCompanyRequestJSON {
  id: string;
}

const DeleteCompanyRequestToJSON = (m: DeleteCompanyRequest): DeleteCompanyRequestJSON => {
  return {
    id: m.id,
  };
};

export interface ListCompaniesRequest {
  limit: number;
  offset: number;
  hasGamesPending: boolean;
  ownsGameId: number;
  hasDevelopersPending: boolean;
}
interface ListCompaniesRequestJSON {
  limit: number;
  offset: number;
  has_games_pending: boolean;
  owns_game_id: number;
  has_developers_pending: boolean;
}

const ListCompaniesRequestToJSON = (m: ListCompaniesRequest): ListCompaniesRequestJSON => {
  return {
    limit: m.limit,
    offset: m.offset,
    has_games_pending: m.hasGamesPending,
    owns_game_id: m.ownsGameId,
    has_developers_pending: m.hasDevelopersPending,
  };
};

export interface ListCompaniesResponse {
  companies: Company[];
  Total: number;
}
interface ListCompaniesResponseJSON {
  companies: CompanyJSON[];
  _total: number;
}

const JSONToListCompaniesResponse = (m: ListCompaniesResponse | ListCompaniesResponseJSON): ListCompaniesResponse => {
  if (!m) {
    return {
      companies: [],
      Total: 0,
    };
  }

  return {
    companies: ((m.companies as (Company | CompanyJSON)[]) || []).map(JSONToCompany),
    Total:
      ((m as ListCompaniesResponse).Total
        ? (m as ListCompaniesResponse).Total
        : (m as ListCompaniesResponseJSON)._total) || 0,
  };
};

export interface UpdateCompanyRequest {
  id: string;
  companyname: string;
  url: string;
  type: number;
  vhsContractsigned: boolean;
  campaignsenabled: boolean;
  identifier: string;
  cursecompanyId: number;
}
interface UpdateCompanyRequestJSON {
  id: string;
  companyName: string;
  url: string;
  type: number;
  vhs_contractSigned: boolean;
  campaignsEnabled: boolean;
  identifier: string;
  curseCompany_id: number;
}

const UpdateCompanyRequestToJSON = (m: UpdateCompanyRequest): UpdateCompanyRequestJSON => {
  return {
    id: m.id,
    companyName: m.companyname,
    url: m.url,
    type: m.type,
    vhs_contractSigned: m.vhsContractsigned,
    campaignsEnabled: m.campaignsenabled,
    identifier: m.identifier,
    curseCompany_id: m.cursecompanyId,
  };
};

export interface CompanyApplication {
  id: string;
  companyName: string;
  companyWebsite: string;
  companyType: number;
  games: Game[];
  industry: string;
  companySize: string;
  city: string;
  state: string;
  country: string;
  contactFirstName: string;
  contactLastName: string;
  contactTitle: string;
  contactEmail: string;
  productInterest: string;
  joinReason: string;
  twitchId: string;
  status: number;
  createdAt: string;
  updatedAt: string;
  emailVerificationStatus: string;
}
interface CompanyApplicationJSON {
  id: string;
  company_name: string;
  company_website: string;
  company_type: number;
  games: GameJSON[];
  industry: string;
  company_size: string;
  city: string;
  state: string;
  country: string;
  contact_first_name: string;
  contact_last_name: string;
  contact_title: string;
  contact_email: string;
  product_interest: string;
  join_reason: string;
  twitch_id: string;
  status: number;
  created_at: string;
  updated_at: string;
  email_verification_status: string;
}

const JSONToCompanyApplication = (m: CompanyApplication | CompanyApplicationJSON): CompanyApplication => {
  if (!m) {
    return {
      id: '',
      companyName: '',
      companyWebsite: '',
      companyType: 0,
      games: [],
      industry: '',
      companySize: '',
      city: '',
      state: '',
      country: '',
      contactFirstName: '',
      contactLastName: '',
      contactTitle: '',
      contactEmail: '',
      productInterest: '',
      joinReason: '',
      twitchId: '',
      status: 0,
      createdAt: '',
      updatedAt: '',
      emailVerificationStatus: '',
    };
  }

  return {
    id: m.id || '',
    companyName:
      ((m as CompanyApplication).companyName
        ? (m as CompanyApplication).companyName
        : (m as CompanyApplicationJSON).company_name) || '',
    companyWebsite:
      ((m as CompanyApplication).companyWebsite
        ? (m as CompanyApplication).companyWebsite
        : (m as CompanyApplicationJSON).company_website) || '',
    companyType:
      ((m as CompanyApplication).companyType
        ? (m as CompanyApplication).companyType
        : (m as CompanyApplicationJSON).company_type) || 0,
    games: ((m.games as (Game | GameJSON)[]) || []).map(JSONToGame),
    industry: m.industry || '',
    companySize:
      ((m as CompanyApplication).companySize
        ? (m as CompanyApplication).companySize
        : (m as CompanyApplicationJSON).company_size) || '',
    city: m.city || '',
    state: m.state || '',
    country: m.country || '',
    contactFirstName:
      ((m as CompanyApplication).contactFirstName
        ? (m as CompanyApplication).contactFirstName
        : (m as CompanyApplicationJSON).contact_first_name) || '',
    contactLastName:
      ((m as CompanyApplication).contactLastName
        ? (m as CompanyApplication).contactLastName
        : (m as CompanyApplicationJSON).contact_last_name) || '',
    contactTitle:
      ((m as CompanyApplication).contactTitle
        ? (m as CompanyApplication).contactTitle
        : (m as CompanyApplicationJSON).contact_title) || '',
    contactEmail:
      ((m as CompanyApplication).contactEmail
        ? (m as CompanyApplication).contactEmail
        : (m as CompanyApplicationJSON).contact_email) || '',
    productInterest:
      ((m as CompanyApplication).productInterest
        ? (m as CompanyApplication).productInterest
        : (m as CompanyApplicationJSON).product_interest) || '',
    joinReason:
      ((m as CompanyApplication).joinReason
        ? (m as CompanyApplication).joinReason
        : (m as CompanyApplicationJSON).join_reason) || '',
    twitchId:
      ((m as CompanyApplication).twitchId
        ? (m as CompanyApplication).twitchId
        : (m as CompanyApplicationJSON).twitch_id) || '',
    status: m.status || 0,
    createdAt:
      ((m as CompanyApplication).createdAt
        ? (m as CompanyApplication).createdAt
        : (m as CompanyApplicationJSON).created_at) || '',
    updatedAt:
      ((m as CompanyApplication).updatedAt
        ? (m as CompanyApplication).updatedAt
        : (m as CompanyApplicationJSON).updated_at) || '',
    emailVerificationStatus:
      ((m as CompanyApplication).emailVerificationStatus
        ? (m as CompanyApplication).emailVerificationStatus
        : (m as CompanyApplicationJSON).email_verification_status) || '',
  };
};

export interface CreateCompanyApplicationRequest {
  companyName: string;
  companyWebsite: string;
  companyType: number;
  games: string[];
  industry: string;
  companySize: string;
  city: string;
  state: string;
  country: string;
  contactFirstName: string;
  contactLastName: string;
  contactTitle: string;
  contactEmail: string;
  productInterest: string;
  joinReason: string;
  twitchId: string;
}
interface CreateCompanyApplicationRequestJSON {
  company_name: string;
  company_website: string;
  company_type: number;
  games: string[];
  industry: string;
  company_size: string;
  city: string;
  state: string;
  country: string;
  contact_first_name: string;
  contact_last_name: string;
  contact_title: string;
  contact_email: string;
  product_interest: string;
  join_reason: string;
  twitch_id: string;
}

const CreateCompanyApplicationRequestToJSON = (
  m: CreateCompanyApplicationRequest,
): CreateCompanyApplicationRequestJSON => {
  return {
    company_name: m.companyName,
    company_website: m.companyWebsite,
    company_type: m.companyType,
    games: m.games,
    industry: m.industry,
    company_size: m.companySize,
    city: m.city,
    state: m.state,
    country: m.country,
    contact_first_name: m.contactFirstName,
    contact_last_name: m.contactLastName,
    contact_title: m.contactTitle,
    contact_email: m.contactEmail,
    product_interest: m.productInterest,
    join_reason: m.joinReason,
    twitch_id: m.twitchId,
  };
};

export interface DeleteCompanyApplicationRequest {
  id: string;
  skipEmail: boolean;
}
interface DeleteCompanyApplicationRequestJSON {
  id: string;
  skip_email: boolean;
}

const DeleteCompanyApplicationRequestToJSON = (
  m: DeleteCompanyApplicationRequest,
): DeleteCompanyApplicationRequestJSON => {
  return {
    id: m.id,
    skip_email: m.skipEmail,
  };
};

export interface ListCompanyApplicationsRequest {
  limit: number;
  offset: number;
  status: number;
  twitchId: string;
}
interface ListCompanyApplicationsRequestJSON {
  limit: number;
  offset: number;
  status: number;
  twitch_id: string;
}

const ListCompanyApplicationsRequestToJSON = (
  m: ListCompanyApplicationsRequest,
): ListCompanyApplicationsRequestJSON => {
  return {
    limit: m.limit,
    offset: m.offset,
    status: m.status,
    twitch_id: m.twitchId,
  };
};

export interface ListCompanyApplicationsResponse {
  companyapplications: CompanyApplication[];
  Total: number;
}
interface ListCompanyApplicationsResponseJSON {
  companyApplications: CompanyApplicationJSON[];
  _total: number;
}

const JSONToListCompanyApplicationsResponse = (
  m: ListCompanyApplicationsResponse | ListCompanyApplicationsResponseJSON,
): ListCompanyApplicationsResponse => {
  if (!m) {
    return {
      companyapplications: [],
      Total: 0,
    };
  }

  return {
    companyapplications: (
      (((m as ListCompanyApplicationsResponse).companyapplications
        ? (m as ListCompanyApplicationsResponse).companyapplications
        : (m as ListCompanyApplicationsResponseJSON).companyApplications) as (
        | CompanyApplication
        | CompanyApplicationJSON)[]) || []
    ).map(JSONToCompanyApplication),
    Total:
      ((m as ListCompanyApplicationsResponse).Total
        ? (m as ListCompanyApplicationsResponse).Total
        : (m as ListCompanyApplicationsResponseJSON)._total) || 0,
  };
};

export interface UpdateCompanyApplicationRequest {
  id: string;
  companyName: string;
  companyWebsite: string;
  companyType: number;
  games: string[];
  industry: string;
  companySize: string;
  city: string;
  state: string;
  country: string;
  contactFirstName: string;
  contactLastName: string;
  contactTitle: string;
  contactEmail: string;
  productInterest: string;
  joinReason: string;
  twitchId: string;
  status: number;
}
interface UpdateCompanyApplicationRequestJSON {
  id: string;
  company_name: string;
  company_website: string;
  company_type: number;
  games: string[];
  industry: string;
  company_size: string;
  city: string;
  state: string;
  country: string;
  contact_first_name: string;
  contact_last_name: string;
  contact_title: string;
  contact_email: string;
  product_interest: string;
  join_reason: string;
  twitch_id: string;
  status: number;
}

const UpdateCompanyApplicationRequestToJSON = (
  m: UpdateCompanyApplicationRequest,
): UpdateCompanyApplicationRequestJSON => {
  return {
    id: m.id,
    company_name: m.companyName,
    company_website: m.companyWebsite,
    company_type: m.companyType,
    games: m.games,
    industry: m.industry,
    company_size: m.companySize,
    city: m.city,
    state: m.state,
    country: m.country,
    contact_first_name: m.contactFirstName,
    contact_last_name: m.contactLastName,
    contact_title: m.contactTitle,
    contact_email: m.contactEmail,
    product_interest: m.productInterest,
    join_reason: m.joinReason,
    twitch_id: m.twitchId,
    status: m.status,
  };
};

export interface OnboardCompanyRequest {
  id: string;
}
interface OnboardCompanyRequestJSON {
  id: string;
}

const OnboardCompanyRequestToJSON = (m: OnboardCompanyRequest): OnboardCompanyRequestJSON => {
  return {
    id: m.id,
  };
};

export interface OnboardCompanyResponse {
  id: string;
  company: Company;
}
interface OnboardCompanyResponseJSON {
  id: string;
  company: CompanyJSON;
}

const JSONToOnboardCompanyResponse = (
  m: OnboardCompanyResponse | OnboardCompanyResponseJSON,
): OnboardCompanyResponse => {
  if (!m) {
    return {
      id: '',
      company: JSONToCompany({} as any),
    };
  }

  return {
    id: m.id || '',
    company: JSONToCompany(m.company),
  };
};

export interface Game {
  id: number;
  giantbombId: number;
  name: string;
}
interface GameJSON {
  id: number;
  giantbomb_id: number;
  name: string;
}

const JSONToGame = (m: Game | GameJSON): Game => {
  if (!m) {
    return {
      id: 0,
      giantbombId: 0,
      name: '',
    };
  }

  return {
    id: m.id || 0,
    giantbombId: ((m as Game).giantbombId ? (m as Game).giantbombId : (m as GameJSON).giantbomb_id) || 0,
    name: m.name || '',
  };
};

export interface GameWithCompany {
  id: number;
  giantbombId: number;
  companyId: string;
  cursecompanyId: number;
  gamename: string;
  legacy: boolean;
}
interface GameWithCompanyJSON {
  id: number;
  giantbomb_id: number;
  company_id: string;
  curseCompany_id: number;
  gamename: string;
  legacy: boolean;
}

const JSONToGameWithCompany = (m: GameWithCompany | GameWithCompanyJSON): GameWithCompany => {
  if (!m) {
    return {
      id: 0,
      giantbombId: 0,
      companyId: '',
      cursecompanyId: 0,
      gamename: '',
      legacy: false,
    };
  }

  return {
    id: m.id || 0,
    giantbombId:
      ((m as GameWithCompany).giantbombId
        ? (m as GameWithCompany).giantbombId
        : (m as GameWithCompanyJSON).giantbomb_id) || 0,
    companyId:
      ((m as GameWithCompany).companyId ? (m as GameWithCompany).companyId : (m as GameWithCompanyJSON).company_id) ||
      '',
    cursecompanyId:
      ((m as GameWithCompany).cursecompanyId
        ? (m as GameWithCompany).cursecompanyId
        : (m as GameWithCompanyJSON).curseCompany_id) || 0,
    gamename: m.gamename || '',
    legacy: m.legacy || false,
  };
};

export interface GetAllGamesWithCompaniesRequest {
  limit: number;
  offset: number;
}
interface GetAllGamesWithCompaniesRequestJSON {
  limit: number;
  offset: number;
}

const GetAllGamesWithCompaniesRequestToJSON = (
  m: GetAllGamesWithCompaniesRequest,
): GetAllGamesWithCompaniesRequestJSON => {
  return {
    limit: m.limit,
    offset: m.offset,
  };
};

export interface GetAllGamesWithCompaniesResponse {
  Total: number;
  games: GameWithCompany[];
}
interface GetAllGamesWithCompaniesResponseJSON {
  _total: number;
  games: GameWithCompanyJSON[];
}

const JSONToGetAllGamesWithCompaniesResponse = (
  m: GetAllGamesWithCompaniesResponse | GetAllGamesWithCompaniesResponseJSON,
): GetAllGamesWithCompaniesResponse => {
  if (!m) {
    return {
      Total: 0,
      games: [],
    };
  }

  return {
    Total:
      ((m as GetAllGamesWithCompaniesResponse).Total
        ? (m as GetAllGamesWithCompaniesResponse).Total
        : (m as GetAllGamesWithCompaniesResponseJSON)._total) || 0,
    games: ((m.games as (GameWithCompany | GameWithCompanyJSON)[]) || []).map(JSONToGameWithCompany),
  };
};

export interface GetGamesByCompanyResponse {
  Total: number;
  company: Company;
  games: Game[];
}
interface GetGamesByCompanyResponseJSON {
  _total: number;
  company: CompanyJSON;
  games: GameJSON[];
}

const JSONToGetGamesByCompanyResponse = (
  m: GetGamesByCompanyResponse | GetGamesByCompanyResponseJSON,
): GetGamesByCompanyResponse => {
  if (!m) {
    return {
      Total: 0,
      company: JSONToCompany({} as any),
      games: [],
    };
  }

  return {
    Total:
      ((m as GetGamesByCompanyResponse).Total
        ? (m as GetGamesByCompanyResponse).Total
        : (m as GetGamesByCompanyResponseJSON)._total) || 0,
    company: JSONToCompany(m.company),
    games: ((m.games as (Game | GameJSON)[]) || []).map(JSONToGame),
  };
};

export interface GetGamesByTwitchIDResponse {
  Total: number;
  games: Game[];
}
interface GetGamesByTwitchIDResponseJSON {
  _total: number;
  games: GameJSON[];
}

const JSONToGetGamesByTwitchIDResponse = (
  m: GetGamesByTwitchIDResponse | GetGamesByTwitchIDResponseJSON,
): GetGamesByTwitchIDResponse => {
  if (!m) {
    return {
      Total: 0,
      games: [],
    };
  }

  return {
    Total:
      ((m as GetGamesByTwitchIDResponse).Total
        ? (m as GetGamesByTwitchIDResponse).Total
        : (m as GetGamesByTwitchIDResponseJSON)._total) || 0,
    games: ((m.games as (Game | GameJSON)[]) || []).map(JSONToGame),
  };
};

export interface GameApplication {
  id: string;
  gameId: number;
  companyId: string;
  createdat: string;
  gameName: string;
}
interface GameApplicationJSON {
  id: string;
  game_id: number;
  company_id: string;
  createdAt: string;
  game_name: string;
}

const JSONToGameApplication = (m: GameApplication | GameApplicationJSON): GameApplication => {
  if (!m) {
    return {
      id: '',
      gameId: 0,
      companyId: '',
      createdat: '',
      gameName: '',
    };
  }

  return {
    id: m.id || '',
    gameId: ((m as GameApplication).gameId ? (m as GameApplication).gameId : (m as GameApplicationJSON).game_id) || 0,
    companyId:
      ((m as GameApplication).companyId ? (m as GameApplication).companyId : (m as GameApplicationJSON).company_id) ||
      '',
    createdat:
      ((m as GameApplication).createdat ? (m as GameApplication).createdat : (m as GameApplicationJSON).createdAt) ||
      '',
    gameName:
      ((m as GameApplication).gameName ? (m as GameApplication).gameName : (m as GameApplicationJSON).game_name) || '',
  };
};

export interface CreateGameApplicationRequest {
  gameId: number;
  companyId: string;
}
interface CreateGameApplicationRequestJSON {
  game_id: number;
  company_id: string;
}

const CreateGameApplicationRequestToJSON = (m: CreateGameApplicationRequest): CreateGameApplicationRequestJSON => {
  return {
    game_id: m.gameId,
    company_id: m.companyId,
  };
};

export interface CreateGameApplicationRequestV2 {
  gameId: number;
  companyId: string;
  requestingTwitchId: string;
}
interface CreateGameApplicationRequestV2JSON {
  game_id: number;
  company_id: string;
  requesting_twitch_id: string;
}

const CreateGameApplicationRequestV2ToJSON = (
  m: CreateGameApplicationRequestV2,
): CreateGameApplicationRequestV2JSON => {
  return {
    game_id: m.gameId,
    company_id: m.companyId,
    requesting_twitch_id: m.requestingTwitchId,
  };
};

export interface DeleteGameApplicationRequest {
  id: string;
  skipEmail: boolean;
}
interface DeleteGameApplicationRequestJSON {
  id: string;
  skip_email: boolean;
}

const DeleteGameApplicationRequestToJSON = (m: DeleteGameApplicationRequest): DeleteGameApplicationRequestJSON => {
  return {
    id: m.id,
    skip_email: m.skipEmail,
  };
};

export interface DeleteDeveloperApplicationRequest {
  id: string;
  skipEmail: boolean;
}
interface DeleteDeveloperApplicationRequestJSON {
  id: string;
  skip_email: boolean;
}

const DeleteDeveloperApplicationRequestToJSON = (
  m: DeleteDeveloperApplicationRequest,
): DeleteDeveloperApplicationRequestJSON => {
  return {
    id: m.id,
    skip_email: m.skipEmail,
  };
};

export interface GetGameApplicationsByCompanyResponse {
  gameapplications: GameApplication[];
  Total: number;
}
interface GetGameApplicationsByCompanyResponseJSON {
  gameApplications: GameApplicationJSON[];
  _total: number;
}

const JSONToGetGameApplicationsByCompanyResponse = (
  m: GetGameApplicationsByCompanyResponse | GetGameApplicationsByCompanyResponseJSON,
): GetGameApplicationsByCompanyResponse => {
  if (!m) {
    return {
      gameapplications: [],
      Total: 0,
    };
  }

  return {
    gameapplications: (
      (((m as GetGameApplicationsByCompanyResponse).gameapplications
        ? (m as GetGameApplicationsByCompanyResponse).gameapplications
        : (m as GetGameApplicationsByCompanyResponseJSON).gameApplications) as (
        | GameApplication
        | GameApplicationJSON)[]) || []
    ).map(JSONToGameApplication),
    Total:
      ((m as GetGameApplicationsByCompanyResponse).Total
        ? (m as GetGameApplicationsByCompanyResponse).Total
        : (m as GetGameApplicationsByCompanyResponseJSON)._total) || 0,
  };
};

export interface GetDeveloperApplicationsRequest {
  companyId: string;
  limit: number;
  offset: number;
}
interface GetDeveloperApplicationsRequestJSON {
  company_id: string;
  limit: number;
  offset: number;
}

const GetDeveloperApplicationsRequestToJSON = (
  m: GetDeveloperApplicationsRequest,
): GetDeveloperApplicationsRequestJSON => {
  return {
    company_id: m.companyId,
    limit: m.limit,
    offset: m.offset,
  };
};

export interface GetDeveloperApplicationsResponse {
  developerApplications: DeveloperApplication[];
  Total: number;
}
interface GetDeveloperApplicationsResponseJSON {
  developer_applications: DeveloperApplicationJSON[];
  _total: number;
}

const JSONToGetDeveloperApplicationsResponse = (
  m: GetDeveloperApplicationsResponse | GetDeveloperApplicationsResponseJSON,
): GetDeveloperApplicationsResponse => {
  if (!m) {
    return {
      developerApplications: [],
      Total: 0,
    };
  }

  return {
    developerApplications: (
      (((m as GetDeveloperApplicationsResponse).developerApplications
        ? (m as GetDeveloperApplicationsResponse).developerApplications
        : (m as GetDeveloperApplicationsResponseJSON).developer_applications) as (
        | DeveloperApplication
        | DeveloperApplicationJSON)[]) || []
    ).map(JSONToDeveloperApplication),
    Total:
      ((m as GetDeveloperApplicationsResponse).Total
        ? (m as GetDeveloperApplicationsResponse).Total
        : (m as GetDeveloperApplicationsResponseJSON)._total) || 0,
  };
};

export interface DeveloperApplication {
  id: string;
  companyId: string;
  twitchId: string;
  firstName: string;
  lastName: string;
  title: string;
  email: string;
  createdAt: string;
  emailVerificationStatus: string;
}
interface DeveloperApplicationJSON {
  id: string;
  company_id: string;
  twitch_id: string;
  first_name: string;
  last_name: string;
  title: string;
  email: string;
  created_at: string;
  email_verification_status: string;
}

const JSONToDeveloperApplication = (m: DeveloperApplication | DeveloperApplicationJSON): DeveloperApplication => {
  if (!m) {
    return {
      id: '',
      companyId: '',
      twitchId: '',
      firstName: '',
      lastName: '',
      title: '',
      email: '',
      createdAt: '',
      emailVerificationStatus: '',
    };
  }

  return {
    id: m.id || '',
    companyId:
      ((m as DeveloperApplication).companyId
        ? (m as DeveloperApplication).companyId
        : (m as DeveloperApplicationJSON).company_id) || '',
    twitchId:
      ((m as DeveloperApplication).twitchId
        ? (m as DeveloperApplication).twitchId
        : (m as DeveloperApplicationJSON).twitch_id) || '',
    firstName:
      ((m as DeveloperApplication).firstName
        ? (m as DeveloperApplication).firstName
        : (m as DeveloperApplicationJSON).first_name) || '',
    lastName:
      ((m as DeveloperApplication).lastName
        ? (m as DeveloperApplication).lastName
        : (m as DeveloperApplicationJSON).last_name) || '',
    title: m.title || '',
    email: m.email || '',
    createdAt:
      ((m as DeveloperApplication).createdAt
        ? (m as DeveloperApplication).createdAt
        : (m as DeveloperApplicationJSON).created_at) || '',
    emailVerificationStatus:
      ((m as DeveloperApplication).emailVerificationStatus
        ? (m as DeveloperApplication).emailVerificationStatus
        : (m as DeveloperApplicationJSON).email_verification_status) || '',
  };
};

export interface ListGameApplicationsRequest {
  limit: number;
  offset: number;
  gameId: number;
  companyId: string;
}
interface ListGameApplicationsRequestJSON {
  limit: number;
  offset: number;
  game_id: number;
  company_id: string;
}

const ListGameApplicationsRequestToJSON = (m: ListGameApplicationsRequest): ListGameApplicationsRequestJSON => {
  return {
    limit: m.limit,
    offset: m.offset,
    game_id: m.gameId,
    company_id: m.companyId,
  };
};

export interface ListGameApplicationsResponse {
  gameapplications: GameApplication[];
  Total: number;
}
interface ListGameApplicationsResponseJSON {
  gameApplications: GameApplicationJSON[];
  _total: number;
}

const JSONToListGameApplicationsResponse = (
  m: ListGameApplicationsResponse | ListGameApplicationsResponseJSON,
): ListGameApplicationsResponse => {
  if (!m) {
    return {
      gameapplications: [],
      Total: 0,
    };
  }

  return {
    gameapplications: (
      (((m as ListGameApplicationsResponse).gameapplications
        ? (m as ListGameApplicationsResponse).gameapplications
        : (m as ListGameApplicationsResponseJSON).gameApplications) as (GameApplication | GameApplicationJSON)[]) || []
    ).map(JSONToGameApplication),
    Total:
      ((m as ListGameApplicationsResponse).Total
        ? (m as ListGameApplicationsResponse).Total
        : (m as ListGameApplicationsResponseJSON)._total) || 0,
  };
};

export interface Name {
  name: string;
}
interface NameJSON {
  name: string;
}

export interface UpdateUserRequest {
  twitchId: string;
  companyId: string;
  firstName: string;
  lastName: string;
  devTitle: string;
  devEmail: string;
}
interface UpdateUserRequestJSON {
  twitch_id: string;
  company_id: string;
  first_name: string;
  last_name: string;
  dev_title: string;
  dev_email: string;
}

const UpdateUserRequestToJSON = (m: UpdateUserRequest): UpdateUserRequestJSON => {
  return {
    twitch_id: m.twitchId,
    company_id: m.companyId,
    first_name: m.firstName,
    last_name: m.lastName,
    dev_title: m.devTitle,
    dev_email: m.devEmail,
  };
};

export interface GetMembershipRequest {
  companyId: string;
  twitchId: string;
  requestingTwitchId: string;
}
interface GetMembershipRequestJSON {
  company_id: string;
  twitch_id: string;
  requesting_twitch_id: string;
}

const GetMembershipRequestToJSON = (m: GetMembershipRequest): GetMembershipRequestJSON => {
  return {
    company_id: m.companyId,
    twitch_id: m.twitchId,
    requesting_twitch_id: m.requestingTwitchId,
  };
};

export interface Membership {
  twitchId: string;
  companyId: string;
  role: string;
  firstName: string;
  lastName: string;
  devTitle: string;
  devEmail: string;
  createdAt: string;
  modifiedAt: string;
}
interface MembershipJSON {
  twitch_id: string;
  company_id: string;
  role: string;
  first_name: string;
  last_name: string;
  dev_title: string;
  dev_email: string;
  created_at: string;
  modified_at: string;
}

const JSONToMembership = (m: Membership | MembershipJSON): Membership => {
  if (!m) {
    return {
      twitchId: '',
      companyId: '',
      role: '',
      firstName: '',
      lastName: '',
      devTitle: '',
      devEmail: '',
      createdAt: '',
      modifiedAt: '',
    };
  }

  return {
    twitchId: ((m as Membership).twitchId ? (m as Membership).twitchId : (m as MembershipJSON).twitch_id) || '',
    companyId: ((m as Membership).companyId ? (m as Membership).companyId : (m as MembershipJSON).company_id) || '',
    role: m.role || '',
    firstName: ((m as Membership).firstName ? (m as Membership).firstName : (m as MembershipJSON).first_name) || '',
    lastName: ((m as Membership).lastName ? (m as Membership).lastName : (m as MembershipJSON).last_name) || '',
    devTitle: ((m as Membership).devTitle ? (m as Membership).devTitle : (m as MembershipJSON).dev_title) || '',
    devEmail: ((m as Membership).devEmail ? (m as Membership).devEmail : (m as MembershipJSON).dev_email) || '',
    createdAt: ((m as Membership).createdAt ? (m as Membership).createdAt : (m as MembershipJSON).created_at) || '',
    modifiedAt: ((m as Membership).modifiedAt ? (m as Membership).modifiedAt : (m as MembershipJSON).modified_at) || '',
  };
};

export interface UserWhitelist {
  twitchId: string;
  role: string;
}
interface UserWhitelistJSON {
  twitch_id: string;
  role: string;
}

const JSONToUserWhitelist = (m: UserWhitelist | UserWhitelistJSON): UserWhitelist => {
  if (!m) {
    return {
      twitchId: '',
      role: '',
    };
  }

  return {
    twitchId:
      ((m as UserWhitelist).twitchId ? (m as UserWhitelist).twitchId : (m as UserWhitelistJSON).twitch_id) || '',
    role: m.role || '',
  };
};

export interface GetUsersByCompanyIdRequest {
  id: string;
  offset: number;
  limit: number;
  sortBy: string;
  orderBy: string;
  role: string;
}
interface GetUsersByCompanyIdRequestJSON {
  id: string;
  offset: number;
  limit: number;
  sort_by: string;
  order_by: string;
  role: string;
}

const GetUsersByCompanyIdRequestToJSON = (m: GetUsersByCompanyIdRequest): GetUsersByCompanyIdRequestJSON => {
  return {
    id: m.id,
    offset: m.offset,
    limit: m.limit,
    sort_by: m.sortBy,
    order_by: m.orderBy,
    role: m.role,
  };
};

export interface GetUsersByCompanyIdResponse {
  id: string;
  memberships: Membership[];
  total: number;
  offset: number;
}
interface GetUsersByCompanyIdResponseJSON {
  id: string;
  memberships: MembershipJSON[];
  total: number;
  offset: number;
}

const JSONToGetUsersByCompanyIdResponse = (
  m: GetUsersByCompanyIdResponse | GetUsersByCompanyIdResponseJSON,
): GetUsersByCompanyIdResponse => {
  if (!m) {
    return {
      id: '',
      memberships: [],
      total: 0,
      offset: 0,
    };
  }

  return {
    id: m.id || '',
    memberships: ((m.memberships as (Membership | MembershipJSON)[]) || []).map(JSONToMembership),
    total: m.total || 0,
    offset: m.offset || 0,
  };
};

export interface UpdateUserRoleRequest {
  companyId: string;
  role: string;
  twitchId: string;
  requestingTwitchId: string;
}
interface UpdateUserRoleRequestJSON {
  company_id: string;
  role: string;
  twitch_id: string;
  requesting_twitch_id: string;
}

const UpdateUserRoleRequestToJSON = (m: UpdateUserRoleRequest): UpdateUserRoleRequestJSON => {
  return {
    company_id: m.companyId,
    role: m.role,
    twitch_id: m.twitchId,
    requesting_twitch_id: m.requestingTwitchId,
  };
};

export interface ListAllRolesResponse {
  roles: string[];
}
interface ListAllRolesResponseJSON {
  roles: string[];
}

const JSONToListAllRolesResponse = (m: ListAllRolesResponse | ListAllRolesResponseJSON): ListAllRolesResponse => {
  if (!m) {
    return {
      roles: [],
    };
  }

  return {
    roles: m.roles,
  };
};

export interface SearchCompaniesRequest {
  query: string;
  limit: number;
}
interface SearchCompaniesRequestJSON {
  query: string;
  limit: number;
}

const SearchCompaniesRequestToJSON = (m: SearchCompaniesRequest): SearchCompaniesRequestJSON => {
  return {
    query: m.query,
    limit: m.limit,
  };
};

export interface SearchCompaniesResponse {
  companies: Company[];
  Total: number;
}
interface SearchCompaniesResponseJSON {
  companies: CompanyJSON[];
  _total: number;
}

const JSONToSearchCompaniesResponse = (
  m: SearchCompaniesResponse | SearchCompaniesResponseJSON,
): SearchCompaniesResponse => {
  if (!m) {
    return {
      companies: [],
      Total: 0,
    };
  }

  return {
    companies: ((m.companies as (Company | CompanyJSON)[]) || []).map(JSONToCompany),
    Total:
      ((m as SearchCompaniesResponse).Total
        ? (m as SearchCompaniesResponse).Total
        : (m as SearchCompaniesResponseJSON)._total) || 0,
  };
};

export interface SearchCompanyApplicationsRequest {
  query: string;
  limit: number;
}
interface SearchCompanyApplicationsRequestJSON {
  query: string;
  limit: number;
}

const SearchCompanyApplicationsRequestToJSON = (
  m: SearchCompanyApplicationsRequest,
): SearchCompanyApplicationsRequestJSON => {
  return {
    query: m.query,
    limit: m.limit,
  };
};

export interface SearchCompanyApplicationsResponse {
  companyapplications: CompanyApplication[];
  Total: number;
}
interface SearchCompanyApplicationsResponseJSON {
  companyApplications: CompanyApplicationJSON[];
  _total: number;
}

const JSONToSearchCompanyApplicationsResponse = (
  m: SearchCompanyApplicationsResponse | SearchCompanyApplicationsResponseJSON,
): SearchCompanyApplicationsResponse => {
  if (!m) {
    return {
      companyapplications: [],
      Total: 0,
    };
  }

  return {
    companyapplications: (
      (((m as SearchCompanyApplicationsResponse).companyapplications
        ? (m as SearchCompanyApplicationsResponse).companyapplications
        : (m as SearchCompanyApplicationsResponseJSON).companyApplications) as (
        | CompanyApplication
        | CompanyApplicationJSON)[]) || []
    ).map(JSONToCompanyApplication),
    Total:
      ((m as SearchCompanyApplicationsResponse).Total
        ? (m as SearchCompanyApplicationsResponse).Total
        : (m as SearchCompanyApplicationsResponseJSON)._total) || 0,
  };
};

export interface ValidateQuery {
  userId: string;
  permission: string;
  resourceId: string;
  resourceType: string;
}
interface ValidateQueryJSON {
  user_id: string;
  permission: string;
  resource_id: string;
  resource_type: string;
}

const ValidateQueryToJSON = (m: ValidateQuery): ValidateQueryJSON => {
  return {
    user_id: m.userId,
    permission: m.permission,
    resource_id: m.resourceId,
    resource_type: m.resourceType,
  };
};

export interface ValidateResponse {
  valid: boolean;
}
interface ValidateResponseJSON {
  valid: boolean;
}

const JSONToValidateResponse = (m: ValidateResponse | ValidateResponseJSON): ValidateResponse => {
  if (!m) {
    return {
      valid: false,
    };
  }

  return {
    valid: m.valid || false,
  };
};

export interface JWT {
  token: string;
  accountId: string;
}
interface JWTJSON {
  token: string;
  account_id: string;
}

const JSONToJWT = (m: JWT | JWTJSON): JWT => {
  if (!m) {
    return {
      token: '',
      accountId: '',
    };
  }

  return {
    token: m.token || '',
    accountId: ((m as JWT).accountId ? (m as JWT).accountId : (m as JWTJSON).account_id) || '',
  };
};

export interface JWTRequest {
  operation: string;
  companyId: string;
  userId: string;
}
interface JWTRequestJSON {
  operation: string;
  company_id: string;
  user_id: string;
}

const JWTRequestToJSON = (m: JWTRequest): JWTRequestJSON => {
  return {
    operation: m.operation,
    company_id: m.companyId,
    user_id: m.userId,
  };
};

export interface AddUserToCompanyRequest {
  user: CreateUserRequest;
  companyId: string;
  role: string;
  requestingTwitchId: string;
}
interface AddUserToCompanyRequestJSON {
  user: CreateUserRequestJSON;
  company_id: string;
  role: string;
  requesting_twitch_id: string;
}

const AddUserToCompanyRequestToJSON = (m: AddUserToCompanyRequest): AddUserToCompanyRequestJSON => {
  return {
    user: CreateUserRequestToJSON(m.user),
    company_id: m.companyId,
    role: m.role,
    requesting_twitch_id: m.requestingTwitchId,
  };
};

export interface CreateUserRequest {
  twitchId: string;
  firstName: string;
  lastName: string;
  title: string;
  email: string;
}
interface CreateUserRequestJSON {
  twitch_id: string;
  first_name: string;
  last_name: string;
  title: string;
  email: string;
}

const CreateUserRequestToJSON = (m: CreateUserRequest): CreateUserRequestJSON => {
  return {
    twitch_id: m.twitchId,
    first_name: m.firstName,
    last_name: m.lastName,
    title: m.title,
    email: m.email,
  };
};

export interface OnboardGameRequest {
  gameApplicationId: string;
}
interface OnboardGameRequestJSON {
  game_application_id: string;
}

const OnboardGameRequestToJSON = (m: OnboardGameRequest): OnboardGameRequestJSON => {
  return {
    game_application_id: m.gameApplicationId,
  };
};

export interface OnboardGameResponse {
  gameId: number;
  gameName: string;
}
interface OnboardGameResponseJSON {
  game_id: number;
  game_name: string;
}

const JSONToOnboardGameResponse = (m: OnboardGameResponse | OnboardGameResponseJSON): OnboardGameResponse => {
  if (!m) {
    return {
      gameId: 0,
      gameName: '',
    };
  }

  return {
    gameId:
      ((m as OnboardGameResponse).gameId
        ? (m as OnboardGameResponse).gameId
        : (m as OnboardGameResponseJSON).game_id) || 0,
    gameName:
      ((m as OnboardGameResponse).gameName
        ? (m as OnboardGameResponse).gameName
        : (m as OnboardGameResponseJSON).game_name) || '',
  };
};

export interface OffboardResourceRequest {
  companyId: string;
  resourceId: string;
  resourceType: string;
}
interface OffboardResourceRequestJSON {
  company_id: string;
  resource_id: string;
  resource_type: string;
}

const OffboardResourceRequestToJSON = (m: OffboardResourceRequest): OffboardResourceRequestJSON => {
  return {
    company_id: m.companyId,
    resource_id: m.resourceId,
    resource_type: m.resourceType,
  };
};

export interface OnboardDeveloperRequest {
  developerApplicationId: string;
  roleId: string;
  role: string;
}
interface OnboardDeveloperRequestJSON {
  developer_application_id: string;
  role_id: string;
  role: string;
}

const OnboardDeveloperRequestToJSON = (m: OnboardDeveloperRequest): OnboardDeveloperRequestJSON => {
  return {
    developer_application_id: m.developerApplicationId,
    role_id: m.roleId,
    role: m.role,
  };
};

export interface OnboardDeveloperResponse {}
interface OnboardDeveloperResponseJSON {}

const JSONToOnboardDeveloperResponse = (
  m: OnboardDeveloperResponse | OnboardDeveloperResponseJSON,
): OnboardDeveloperResponse => {
  if (!m) {
    return {};
  }

  return {};
};

export interface Resource {
  externalId: string;
  type: string;
}
interface ResourceJSON {
  external_id: string;
  type: string;
}

const ResourceToJSON = (m: Resource): ResourceJSON => {
  return {
    external_id: m.externalId,
    type: m.type,
  };
};

const JSONToResource = (m: Resource | ResourceJSON): Resource => {
  if (!m) {
    return {
      externalId: '',
      type: '',
    };
  }

  return {
    externalId: ((m as Resource).externalId ? (m as Resource).externalId : (m as ResourceJSON).external_id) || '',
    type: m.type || '',
  };
};

export interface CreateResourceRequest {
  companyId: string;
  resource: Resource;
}
interface CreateResourceRequestJSON {
  company_id: string;
  resource: ResourceJSON;
}

const CreateResourceRequestToJSON = (m: CreateResourceRequest): CreateResourceRequestJSON => {
  return {
    company_id: m.companyId,
    resource: ResourceToJSON(m.resource),
  };
};

export interface CreateResourceResponse {}
interface CreateResourceResponseJSON {}

const JSONToCreateResourceResponse = (
  m: CreateResourceResponse | CreateResourceResponseJSON,
): CreateResourceResponse => {
  if (!m) {
    return {};
  }

  return {};
};

export interface ListResourcesRequest {
  companyId: string;
  resourceType: string;
  limit: number;
  offset: number;
}
interface ListResourcesRequestJSON {
  company_id: string;
  resource_type: string;
  limit: number;
  offset: number;
}

const ListResourcesRequestToJSON = (m: ListResourcesRequest): ListResourcesRequestJSON => {
  return {
    company_id: m.companyId,
    resource_type: m.resourceType,
    limit: m.limit,
    offset: m.offset,
  };
};

export interface ListResourcesResponse {
  resources: Resource[];
  Total: number;
}
interface ListResourcesResponseJSON {
  resources: ResourceJSON[];
  _total: number;
}

const JSONToListResourcesResponse = (m: ListResourcesResponse | ListResourcesResponseJSON): ListResourcesResponse => {
  if (!m) {
    return {
      resources: [],
      Total: 0,
    };
  }

  return {
    resources: ((m.resources as (Resource | ResourceJSON)[]) || []).map(JSONToResource),
    Total:
      ((m as ListResourcesResponse).Total
        ? (m as ListResourcesResponse).Total
        : (m as ListResourcesResponseJSON)._total) || 0,
  };
};

export interface WhitelistUserRequest {
  twitchId: string;
  role: string;
}
interface WhitelistUserRequestJSON {
  twitch_id: string;
  role: string;
}

const WhitelistUserRequestToJSON = (m: WhitelistUserRequest): WhitelistUserRequestJSON => {
  return {
    twitch_id: m.twitchId,
    role: m.role,
  };
};

export interface RemoveUserFromWhitelistRequest {
  twitchId: string;
}
interface RemoveUserFromWhitelistRequestJSON {
  twitch_id: string;
}

const RemoveUserFromWhitelistRequestToJSON = (
  m: RemoveUserFromWhitelistRequest,
): RemoveUserFromWhitelistRequestJSON => {
  return {
    twitch_id: m.twitchId,
  };
};

export interface ListUserWhitelistByRoleRequest {
  role: string;
  offset: number;
  limit: number;
}
interface ListUserWhitelistByRoleRequestJSON {
  role: string;
  offset: number;
  limit: number;
}

const ListUserWhitelistByRoleRequestToJSON = (
  m: ListUserWhitelistByRoleRequest,
): ListUserWhitelistByRoleRequestJSON => {
  return {
    role: m.role,
    offset: m.offset,
    limit: m.limit,
  };
};

export interface ListUserWhitelistByRoleResponse {
  users: UserWhitelist[];
  total: number;
}
interface ListUserWhitelistByRoleResponseJSON {
  users: UserWhitelistJSON[];
  total: number;
}

const JSONToListUserWhitelistByRoleResponse = (
  m: ListUserWhitelistByRoleResponse | ListUserWhitelistByRoleResponseJSON,
): ListUserWhitelistByRoleResponse => {
  if (!m) {
    return {
      users: [],
      total: 0,
    };
  }

  return {
    users: ((m.users as (UserWhitelist | UserWhitelistJSON)[]) || []).map(JSONToUserWhitelist),
    total: m.total || 0,
  };
};

export interface ListCompanyMembershipsRequest {
  twitchId: string;
}
interface ListCompanyMembershipsRequestJSON {
  twitch_id: string;
}

const ListCompanyMembershipsRequestToJSON = (m: ListCompanyMembershipsRequest): ListCompanyMembershipsRequestJSON => {
  return {
    twitch_id: m.twitchId,
  };
};

export interface CompanyMembership {
  company: Company;
  role: string;
  selfCanLeave: boolean;
  selfCanAddMember: boolean;
  selfCanRemoveMember: boolean;
  joinedAt: string;
}
interface CompanyMembershipJSON {
  company: CompanyJSON;
  role: string;
  self_can_leave: boolean;
  self_can_add_member: boolean;
  self_can_remove_member: boolean;
  joined_at: string;
}

const JSONToCompanyMembership = (m: CompanyMembership | CompanyMembershipJSON): CompanyMembership => {
  if (!m) {
    return {
      company: JSONToCompany({} as any),
      role: '',
      selfCanLeave: false,
      selfCanAddMember: false,
      selfCanRemoveMember: false,
      joinedAt: '',
    };
  }

  return {
    company: JSONToCompany(m.company),
    role: m.role || '',
    selfCanLeave:
      ((m as CompanyMembership).selfCanLeave
        ? (m as CompanyMembership).selfCanLeave
        : (m as CompanyMembershipJSON).self_can_leave) || false,
    selfCanAddMember:
      ((m as CompanyMembership).selfCanAddMember
        ? (m as CompanyMembership).selfCanAddMember
        : (m as CompanyMembershipJSON).self_can_add_member) || false,
    selfCanRemoveMember:
      ((m as CompanyMembership).selfCanRemoveMember
        ? (m as CompanyMembership).selfCanRemoveMember
        : (m as CompanyMembershipJSON).self_can_remove_member) || false,
    joinedAt:
      ((m as CompanyMembership).joinedAt
        ? (m as CompanyMembership).joinedAt
        : (m as CompanyMembershipJSON).joined_at) || '',
  };
};

export interface ListCompanyMembershipsResponse {
  memberships: CompanyMembership[];
}
interface ListCompanyMembershipsResponseJSON {
  memberships: CompanyMembershipJSON[];
}

const JSONToListCompanyMembershipsResponse = (
  m: ListCompanyMembershipsResponse | ListCompanyMembershipsResponseJSON,
): ListCompanyMembershipsResponse => {
  if (!m) {
    return {
      memberships: [],
    };
  }

  return {
    memberships: ((m.memberships as (CompanyMembership | CompanyMembershipJSON)[]) || []).map(JSONToCompanyMembership),
  };
};

export interface GetFeatureGatingValueRequest {
  key: string;
}
interface GetFeatureGatingValueRequestJSON {
  key: string;
}

const GetFeatureGatingValueRequestToJSON = (m: GetFeatureGatingValueRequest): GetFeatureGatingValueRequestJSON => {
  return {
    key: m.key,
  };
};

export interface GetFeatureGatingValueResponse {
  key: string;
  valueInBool: boolean;
  valuesInString: string[];
}
interface GetFeatureGatingValueResponseJSON {
  key: string;
  value_in_bool: boolean;
  values_in_string: string[];
}

const JSONToGetFeatureGatingValueResponse = (
  m: GetFeatureGatingValueResponse | GetFeatureGatingValueResponseJSON,
): GetFeatureGatingValueResponse => {
  if (!m) {
    return {
      key: '',
      valueInBool: false,
      valuesInString: [],
    };
  }

  return {
    key: m.key || '',
    valueInBool:
      ((m as GetFeatureGatingValueResponse).valueInBool
        ? (m as GetFeatureGatingValueResponse).valueInBool
        : (m as GetFeatureGatingValueResponseJSON).value_in_bool) || false,
    valuesInString: (m as GetFeatureGatingValueResponse).valuesInString
      ? (m as GetFeatureGatingValueResponse).valuesInString
      : (m as GetFeatureGatingValueResponseJSON).values_in_string,
  };
};

export interface SetFeatureGatingBoolValueRequest {
  key: string;
  valueInBool: boolean;
}
interface SetFeatureGatingBoolValueRequestJSON {
  key: string;
  value_in_bool: boolean;
}

const SetFeatureGatingBoolValueRequestToJSON = (
  m: SetFeatureGatingBoolValueRequest,
): SetFeatureGatingBoolValueRequestJSON => {
  return {
    key: m.key,
    value_in_bool: m.valueInBool,
  };
};

export interface UpdateFeatureGatingValueRequest {
  key: string;
  valueInString: string;
  action: string;
}
interface UpdateFeatureGatingValueRequestJSON {
  key: string;
  value_in_string: string;
  action: string;
}

const UpdateFeatureGatingValueRequestToJSON = (
  m: UpdateFeatureGatingValueRequest,
): UpdateFeatureGatingValueRequestJSON => {
  return {
    key: m.key,
    value_in_string: m.valueInString,
    action: m.action,
  };
};

export interface RemoveCompanyMembershipRequest {
  companyId: string;
  twitchId: string;
  requestingTwitchId: string;
}
interface RemoveCompanyMembershipRequestJSON {
  company_id: string;
  twitch_id: string;
  requesting_twitch_id: string;
}

const RemoveCompanyMembershipRequestToJSON = (
  m: RemoveCompanyMembershipRequest,
): RemoveCompanyMembershipRequestJSON => {
  return {
    company_id: m.companyId,
    twitch_id: m.twitchId,
    requesting_twitch_id: m.requestingTwitchId,
  };
};

export interface IsFeatureEnabledRequest {
  featureGatingKey: string;
}
interface IsFeatureEnabledRequestJSON {
  feature_gating_key: string;
}

const IsFeatureEnabledRequestToJSON = (m: IsFeatureEnabledRequest): IsFeatureEnabledRequestJSON => {
  return {
    feature_gating_key: m.featureGatingKey,
  };
};

export interface FeatureEnabledResponse {
  enabled: boolean;
}
interface FeatureEnabledResponseJSON {
  enabled: boolean;
}

const JSONToFeatureEnabledResponse = (
  m: FeatureEnabledResponse | FeatureEnabledResponseJSON,
): FeatureEnabledResponse => {
  if (!m) {
    return {
      enabled: false,
    };
  }

  return {
    enabled: m.enabled || false,
  };
};

export interface IsValueEnabledRequest {
  featureGatingKey: string;
  valueInString: string;
}
interface IsValueEnabledRequestJSON {
  feature_gating_key: string;
  value_in_string: string;
}

const IsValueEnabledRequestToJSON = (m: IsValueEnabledRequest): IsValueEnabledRequestJSON => {
  return {
    feature_gating_key: m.featureGatingKey,
    value_in_string: m.valueInString,
  };
};

export interface ExtensionBillingManager {
  extensionClientId: string;
  billingManagerTwitchId: string;
  createdAt: string;
  updatedAt: string;
}
interface ExtensionBillingManagerJSON {
  extension_client_id: string;
  billing_manager_twitch_id: string;
  created_at: string;
  updated_at: string;
}

const JSONToExtensionBillingManager = (
  m: ExtensionBillingManager | ExtensionBillingManagerJSON,
): ExtensionBillingManager => {
  if (!m) {
    return {
      extensionClientId: '',
      billingManagerTwitchId: '',
      createdAt: '',
      updatedAt: '',
    };
  }

  return {
    extensionClientId:
      ((m as ExtensionBillingManager).extensionClientId
        ? (m as ExtensionBillingManager).extensionClientId
        : (m as ExtensionBillingManagerJSON).extension_client_id) || '',
    billingManagerTwitchId:
      ((m as ExtensionBillingManager).billingManagerTwitchId
        ? (m as ExtensionBillingManager).billingManagerTwitchId
        : (m as ExtensionBillingManagerJSON).billing_manager_twitch_id) || '',
    createdAt:
      ((m as ExtensionBillingManager).createdAt
        ? (m as ExtensionBillingManager).createdAt
        : (m as ExtensionBillingManagerJSON).created_at) || '',
    updatedAt:
      ((m as ExtensionBillingManager).updatedAt
        ? (m as ExtensionBillingManager).updatedAt
        : (m as ExtensionBillingManagerJSON).updated_at) || '',
  };
};

export interface SetExtensionBillingManagerRequest {
  extensionClientId: string;
  billingManagerTwitchId: string;
  requestingTwitchId: string;
}
interface SetExtensionBillingManagerRequestJSON {
  extension_client_id: string;
  billing_manager_twitch_id: string;
  requesting_twitch_id: string;
}

const SetExtensionBillingManagerRequestToJSON = (
  m: SetExtensionBillingManagerRequest,
): SetExtensionBillingManagerRequestJSON => {
  return {
    extension_client_id: m.extensionClientId,
    billing_manager_twitch_id: m.billingManagerTwitchId,
    requesting_twitch_id: m.requestingTwitchId,
  };
};

export interface SetExtensionBillingManagerResponse {
  extensionBillingManager: ExtensionBillingManager;
}
interface SetExtensionBillingManagerResponseJSON {
  extension_billing_manager: ExtensionBillingManagerJSON;
}

const JSONToSetExtensionBillingManagerResponse = (
  m: SetExtensionBillingManagerResponse | SetExtensionBillingManagerResponseJSON,
): SetExtensionBillingManagerResponse => {
  if (!m) {
    return {
      extensionBillingManager: JSONToExtensionBillingManager({} as any),
    };
  }

  return {
    extensionBillingManager: JSONToExtensionBillingManager(
      (m as SetExtensionBillingManagerResponse).extensionBillingManager
        ? (m as SetExtensionBillingManagerResponse).extensionBillingManager
        : (m as SetExtensionBillingManagerResponseJSON).extension_billing_manager,
    ),
  };
};

export interface GetExtensionBillingManagerRequest {
  extensionClientId: string;
  requestingTwitchId: string;
}
interface GetExtensionBillingManagerRequestJSON {
  extension_client_id: string;
  requesting_twitch_id: string;
}

const GetExtensionBillingManagerRequestToJSON = (
  m: GetExtensionBillingManagerRequest,
): GetExtensionBillingManagerRequestJSON => {
  return {
    extension_client_id: m.extensionClientId,
    requesting_twitch_id: m.requestingTwitchId,
  };
};

export interface GetExtensionBillingManagerResponse {
  extensionBillingManager: ExtensionBillingManager;
  isBillingManagerAccountDeleted: boolean;
}
interface GetExtensionBillingManagerResponseJSON {
  extension_billing_manager: ExtensionBillingManagerJSON;
  is_billing_manager_account_deleted: boolean;
}

const JSONToGetExtensionBillingManagerResponse = (
  m: GetExtensionBillingManagerResponse | GetExtensionBillingManagerResponseJSON,
): GetExtensionBillingManagerResponse => {
  if (!m) {
    return {
      extensionBillingManager: JSONToExtensionBillingManager({} as any),
      isBillingManagerAccountDeleted: false,
    };
  }

  return {
    extensionBillingManager: JSONToExtensionBillingManager(
      (m as GetExtensionBillingManagerResponse).extensionBillingManager
        ? (m as GetExtensionBillingManagerResponse).extensionBillingManager
        : (m as GetExtensionBillingManagerResponseJSON).extension_billing_manager,
    ),
    isBillingManagerAccountDeleted:
      ((m as GetExtensionBillingManagerResponse).isBillingManagerAccountDeleted
        ? (m as GetExtensionBillingManagerResponse).isBillingManagerAccountDeleted
        : (m as GetExtensionBillingManagerResponseJSON).is_billing_manager_account_deleted) || false,
  };
};

export interface TransferCompanyOwnershipRequest {
  companyId: string;
  ownersNewRole: string;
  twitchIdToPromote: string;
}
interface TransferCompanyOwnershipRequestJSON {
  company_id: string;
  owners_new_role: string;
  twitch_id_to_promote: string;
}

const TransferCompanyOwnershipRequestToJSON = (
  m: TransferCompanyOwnershipRequest,
): TransferCompanyOwnershipRequestJSON => {
  return {
    company_id: m.companyId,
    owners_new_role: m.ownersNewRole,
    twitch_id_to_promote: m.twitchIdToPromote,
  };
};

export interface CreateShadowAccountRequest {
  companyId: string;
  clientId: string;
  userInput: CreateShadowAccountUserInput[];
}
interface CreateShadowAccountRequestJSON {
  company_id: string;
  client_id: string;
  user_input: CreateShadowAccountUserInputJSON[];
}

const CreateShadowAccountRequestToJSON = (m: CreateShadowAccountRequest): CreateShadowAccountRequestJSON => {
  return {
    company_id: m.companyId,
    client_id: m.clientId,
    user_input: m.userInput.map(CreateShadowAccountUserInputToJSON),
  };
};

export interface CreateShadowAccountUserInput {
  email: string;
  firstName: string;
  lastName: string;
  title: string;
}
interface CreateShadowAccountUserInputJSON {
  email: string;
  first_name: string;
  last_name: string;
  title: string;
}

const CreateShadowAccountUserInputToJSON = (m: CreateShadowAccountUserInput): CreateShadowAccountUserInputJSON => {
  return {
    email: m.email,
    first_name: m.firstName,
    last_name: m.lastName,
    title: m.title,
  };
};

export interface CreateShadowAccountRecord {
  email: string;
  twitchId: string;
  username: string;
  errorMessage: string;
}
interface CreateShadowAccountRecordJSON {
  email: string;
  twitch_id: string;
  username: string;
  error_message: string;
}

const JSONToCreateShadowAccountRecord = (
  m: CreateShadowAccountRecord | CreateShadowAccountRecordJSON,
): CreateShadowAccountRecord => {
  if (!m) {
    return {
      email: '',
      twitchId: '',
      username: '',
      errorMessage: '',
    };
  }

  return {
    email: m.email || '',
    twitchId:
      ((m as CreateShadowAccountRecord).twitchId
        ? (m as CreateShadowAccountRecord).twitchId
        : (m as CreateShadowAccountRecordJSON).twitch_id) || '',
    username: m.username || '',
    errorMessage:
      ((m as CreateShadowAccountRecord).errorMessage
        ? (m as CreateShadowAccountRecord).errorMessage
        : (m as CreateShadowAccountRecordJSON).error_message) || '',
  };
};

export interface CreateShadowAccountResponse {
  error: string;
  records: CreateShadowAccountRecord[];
}
interface CreateShadowAccountResponseJSON {
  error: string;
  records: CreateShadowAccountRecordJSON[];
}

const JSONToCreateShadowAccountResponse = (
  m: CreateShadowAccountResponse | CreateShadowAccountResponseJSON,
): CreateShadowAccountResponse => {
  if (!m) {
    return {
      error: '',
      records: [],
    };
  }

  return {
    error: m.error || '',
    records: ((m.records as (CreateShadowAccountRecord | CreateShadowAccountRecordJSON)[]) || []).map(
      JSONToCreateShadowAccountRecord,
    ),
  };
};

export interface GetPaginatedShadowAccountsRequest {
  limit: number;
  offset: number;
}
interface GetPaginatedShadowAccountsRequestJSON {
  limit: number;
  offset: number;
}

const GetPaginatedShadowAccountsRequestToJSON = (
  m: GetPaginatedShadowAccountsRequest,
): GetPaginatedShadowAccountsRequestJSON => {
  return {
    limit: m.limit,
    offset: m.offset,
  };
};

export interface GetPaginatedShadowAccountsResponse {
  twitchIds: string[];
  nextOffset: number;
}
interface GetPaginatedShadowAccountsResponseJSON {
  twitch_ids: string[];
  next_offset: number;
}

const JSONToGetPaginatedShadowAccountsResponse = (
  m: GetPaginatedShadowAccountsResponse | GetPaginatedShadowAccountsResponseJSON,
): GetPaginatedShadowAccountsResponse => {
  if (!m) {
    return {
      twitchIds: [],
      nextOffset: 0,
    };
  }

  return {
    twitchIds: (m as GetPaginatedShadowAccountsResponse).twitchIds
      ? (m as GetPaginatedShadowAccountsResponse).twitchIds
      : (m as GetPaginatedShadowAccountsResponseJSON).twitch_ids,
    nextOffset:
      ((m as GetPaginatedShadowAccountsResponse).nextOffset
        ? (m as GetPaginatedShadowAccountsResponse).nextOffset
        : (m as GetPaginatedShadowAccountsResponseJSON).next_offset) || 0,
  };
};

export interface RBAC {
  listCompanies: (listCompaniesRequest: ListCompaniesRequest) => Promise<TwirpResponse<ListCompaniesResponse>>;

  listCompanyMemberships: (
    listCompanyMembershipsRequest: ListCompanyMembershipsRequest,
  ) => Promise<TwirpResponse<ListCompanyMembershipsResponse>>;

  searchCompanies: (searchCompaniesRequest: SearchCompaniesRequest) => Promise<TwirpResponse<SearchCompaniesResponse>>;

  getCompany: (id: Id) => Promise<TwirpResponse<Company>>;

  updateCompany: (updateCompanyRequest: UpdateCompanyRequest) => Promise<TwirpResponse<Company>>;

  createCompanyApplication: (
    createCompanyApplicationRequest: CreateCompanyApplicationRequest,
  ) => Promise<TwirpResponse<CompanyApplication>>;

  getMembership: (getMembershipRequest: GetMembershipRequest) => Promise<TwirpResponse<Membership>>;

  getUsersByCompanyId: (
    getUsersByCompanyIdRequest: GetUsersByCompanyIdRequest,
  ) => Promise<TwirpResponse<GetUsersByCompanyIdResponse>>;

  addUserToCompany: (addUserToCompanyRequest: AddUserToCompanyRequest) => Promise<TwirpResponse<Empty>>;

  removeCompanyMembership: (
    removeCompanyMembershipRequest: RemoveCompanyMembershipRequest,
  ) => Promise<TwirpResponse<Empty>>;

  updateUser: (updateUserRequest: UpdateUserRequest) => Promise<TwirpResponse<Empty>>;

  updateUserRole: (updateUserRoleRequest: UpdateUserRoleRequest) => Promise<TwirpResponse<Membership>>;

  listAllRoles: (empty: Empty) => Promise<TwirpResponse<ListAllRolesResponse>>;

  validateByTwitchID: (validateQuery: ValidateQuery) => Promise<TwirpResponse<ValidateResponse>>;

  createResource: (createResourceRequest: CreateResourceRequest) => Promise<TwirpResponse<CreateResourceResponse>>;

  listResources: (listResourcesRequest: ListResourcesRequest) => Promise<TwirpResponse<ListResourcesResponse>>;

  setExtensionBillingManager: (
    setExtensionBillingManagerRequest: SetExtensionBillingManagerRequest,
  ) => Promise<TwirpResponse<SetExtensionBillingManagerResponse>>;

  getExtensionBillingManager: (
    getExtensionBillingManagerRequest: GetExtensionBillingManagerRequest,
  ) => Promise<TwirpResponse<GetExtensionBillingManagerResponse>>;

  getPaginatedShadowAccounts: (
    getPaginatedShadowAccountsRequest: GetPaginatedShadowAccountsRequest,
  ) => Promise<TwirpResponse<GetPaginatedShadowAccountsResponse>>;

  transferExtensionToCompany: (transferExtensionRequest: TransferExtensionRequest) => Promise<TwirpResponse<Empty>>;

  detachExtensionFromCompany: (detachExtensionRequest: DetachExtensionRequest) => Promise<TwirpResponse<Empty>>;

  listCompanyApplications: (
    listCompanyApplicationsRequest: ListCompanyApplicationsRequest,
  ) => Promise<TwirpResponse<ListCompanyApplicationsResponse>>;

  searchCompanyApplications: (
    searchCompanyApplicationsRequest: SearchCompanyApplicationsRequest,
  ) => Promise<TwirpResponse<SearchCompanyApplicationsResponse>>;

  getCompanyApplication: (id: Id) => Promise<TwirpResponse<CompanyApplication>>;

  updateCompanyApplication: (
    updateCompanyApplicationRequest: UpdateCompanyApplicationRequest,
  ) => Promise<TwirpResponse<CompanyApplication>>;

  deleteCompanyApplication: (
    deleteCompanyApplicationRequest: DeleteCompanyApplicationRequest,
  ) => Promise<TwirpResponse<Empty>>;

  onboardCompany: (onboardCompanyRequest: OnboardCompanyRequest) => Promise<TwirpResponse<OnboardCompanyResponse>>;

  listGameApplications: (
    listGameApplicationsRequest: ListGameApplicationsRequest,
  ) => Promise<TwirpResponse<ListGameApplicationsResponse>>;

  getGameApplicationsByCompany: (id: Id) => Promise<TwirpResponse<GetGameApplicationsByCompanyResponse>>;

  getGameApplication: (id: Id) => Promise<TwirpResponse<GameApplication>>;

  createGameApplication: (
    createGameApplicationRequest: CreateGameApplicationRequest,
  ) => Promise<TwirpResponse<GameApplication>>;

  createGameApplicationV2: (
    createGameApplicationRequestV2: CreateGameApplicationRequestV2,
  ) => Promise<TwirpResponse<GameApplication>>;

  deleteGameApplication: (deleteGameApplicationRequest: DeleteGameApplicationRequest) => Promise<TwirpResponse<Empty>>;

  onboardGame: (onboardGameRequest: OnboardGameRequest) => Promise<TwirpResponse<OnboardGameResponse>>;

  getDeveloperApplications: (
    getDeveloperApplicationsRequest: GetDeveloperApplicationsRequest,
  ) => Promise<TwirpResponse<GetDeveloperApplicationsResponse>>;

  deleteDeveloperApplication: (
    deleteDeveloperApplicationRequest: DeleteDeveloperApplicationRequest,
  ) => Promise<TwirpResponse<Empty>>;

  onboardDeveloper: (
    onboardDeveloperRequest: OnboardDeveloperRequest,
  ) => Promise<TwirpResponse<OnboardDeveloperResponse>>;

  getGamesByCompany: (id: Id) => Promise<TwirpResponse<GetGamesByCompanyResponse>>;

  getGamesByTwitchID: (id: Id) => Promise<TwirpResponse<GetGamesByTwitchIDResponse>>;

  getCompanyByTwitchID: (id: Id) => Promise<TwirpResponse<Company>>;

  createJWT: (jWTRequest: JWTRequest) => Promise<TwirpResponse<JWT>>;

  getAllGamesWithCompanies: (
    getAllGamesWithCompaniesRequest: GetAllGamesWithCompaniesRequest,
  ) => Promise<TwirpResponse<GetAllGamesWithCompaniesResponse>>;

  isFeatureEnabled: (
    isFeatureEnabledRequest: IsFeatureEnabledRequest,
  ) => Promise<TwirpResponse<FeatureEnabledResponse>>;

  isValueEnabled: (isValueEnabledRequest: IsValueEnabledRequest) => Promise<TwirpResponse<FeatureEnabledResponse>>;
}

export class DefaultRBAC implements RBAC {
  private hostname: string;
  private fetch: Fetch;
  private writeCamelCase: boolean;
  private pathPrefix = '/twirp/code.justin.tv.devrel.rbac.RBAC/';

  constructor(hostname: string, fetch: Fetch, writeCamelCase = false) {
    this.hostname = hostname;
    this.fetch = fetch;
    this.writeCamelCase = writeCamelCase;
  }
  public async listCompanies(
    listCompaniesRequest: ListCompaniesRequest,
  ): Promise<TwirpResponse<ListCompaniesResponse>> {
    const url = `${this.hostname}${this.pathPrefix}ListCompanies`;
    let body: ListCompaniesRequest | ListCompaniesRequestJSON = listCompaniesRequest;
    if (!this.writeCamelCase) {
      body = ListCompaniesRequestToJSON(listCompaniesRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToListCompaniesResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToListCompaniesResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToListCompaniesResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async listCompanyMemberships(
    listCompanyMembershipsRequest: ListCompanyMembershipsRequest,
  ): Promise<TwirpResponse<ListCompanyMembershipsResponse>> {
    const url = `${this.hostname}${this.pathPrefix}ListCompanyMemberships`;
    let body: ListCompanyMembershipsRequest | ListCompanyMembershipsRequestJSON = listCompanyMembershipsRequest;
    if (!this.writeCamelCase) {
      body = ListCompanyMembershipsRequestToJSON(listCompanyMembershipsRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToListCompanyMembershipsResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToListCompanyMembershipsResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToListCompanyMembershipsResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async searchCompanies(
    searchCompaniesRequest: SearchCompaniesRequest,
  ): Promise<TwirpResponse<SearchCompaniesResponse>> {
    const url = `${this.hostname}${this.pathPrefix}SearchCompanies`;
    let body: SearchCompaniesRequest | SearchCompaniesRequestJSON = searchCompaniesRequest;
    if (!this.writeCamelCase) {
      body = SearchCompaniesRequestToJSON(searchCompaniesRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToSearchCompaniesResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToSearchCompaniesResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToSearchCompaniesResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async getCompany(id: Id): Promise<TwirpResponse<Company>> {
    const url = `${this.hostname}${this.pathPrefix}GetCompany`;
    let body: Id | IdJSON = id;
    if (!this.writeCamelCase) {
      body = IdToJSON(id);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToCompany({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToCompany(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToCompany({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async updateCompany(updateCompanyRequest: UpdateCompanyRequest): Promise<TwirpResponse<Company>> {
    const url = `${this.hostname}${this.pathPrefix}UpdateCompany`;
    let body: UpdateCompanyRequest | UpdateCompanyRequestJSON = updateCompanyRequest;
    if (!this.writeCamelCase) {
      body = UpdateCompanyRequestToJSON(updateCompanyRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToCompany({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToCompany(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToCompany({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async createCompanyApplication(
    createCompanyApplicationRequest: CreateCompanyApplicationRequest,
  ): Promise<TwirpResponse<CompanyApplication>> {
    const url = `${this.hostname}${this.pathPrefix}CreateCompanyApplication`;
    let body: CreateCompanyApplicationRequest | CreateCompanyApplicationRequestJSON = createCompanyApplicationRequest;
    if (!this.writeCamelCase) {
      body = CreateCompanyApplicationRequestToJSON(createCompanyApplicationRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToCompanyApplication({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToCompanyApplication(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToCompanyApplication({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async getMembership(getMembershipRequest: GetMembershipRequest): Promise<TwirpResponse<Membership>> {
    const url = `${this.hostname}${this.pathPrefix}GetMembership`;
    let body: GetMembershipRequest | GetMembershipRequestJSON = getMembershipRequest;
    if (!this.writeCamelCase) {
      body = GetMembershipRequestToJSON(getMembershipRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToMembership({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToMembership(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToMembership({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async getUsersByCompanyId(
    getUsersByCompanyIdRequest: GetUsersByCompanyIdRequest,
  ): Promise<TwirpResponse<GetUsersByCompanyIdResponse>> {
    const url = `${this.hostname}${this.pathPrefix}GetUsersByCompanyId`;
    let body: GetUsersByCompanyIdRequest | GetUsersByCompanyIdRequestJSON = getUsersByCompanyIdRequest;
    if (!this.writeCamelCase) {
      body = GetUsersByCompanyIdRequestToJSON(getUsersByCompanyIdRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToGetUsersByCompanyIdResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToGetUsersByCompanyIdResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToGetUsersByCompanyIdResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async addUserToCompany(addUserToCompanyRequest: AddUserToCompanyRequest): Promise<TwirpResponse<Empty>> {
    const url = `${this.hostname}${this.pathPrefix}AddUserToCompany`;
    let body: AddUserToCompanyRequest | AddUserToCompanyRequestJSON = addUserToCompanyRequest;
    if (!this.writeCamelCase) {
      body = AddUserToCompanyRequestToJSON(addUserToCompanyRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToEmpty({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToEmpty(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToEmpty({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async removeCompanyMembership(
    removeCompanyMembershipRequest: RemoveCompanyMembershipRequest,
  ): Promise<TwirpResponse<Empty>> {
    const url = `${this.hostname}${this.pathPrefix}RemoveCompanyMembership`;
    let body: RemoveCompanyMembershipRequest | RemoveCompanyMembershipRequestJSON = removeCompanyMembershipRequest;
    if (!this.writeCamelCase) {
      body = RemoveCompanyMembershipRequestToJSON(removeCompanyMembershipRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToEmpty({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToEmpty(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToEmpty({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async updateUser(updateUserRequest: UpdateUserRequest): Promise<TwirpResponse<Empty>> {
    const url = `${this.hostname}${this.pathPrefix}UpdateUser`;
    let body: UpdateUserRequest | UpdateUserRequestJSON = updateUserRequest;
    if (!this.writeCamelCase) {
      body = UpdateUserRequestToJSON(updateUserRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToEmpty({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToEmpty(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToEmpty({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async updateUserRole(updateUserRoleRequest: UpdateUserRoleRequest): Promise<TwirpResponse<Membership>> {
    const url = `${this.hostname}${this.pathPrefix}UpdateUserRole`;
    let body: UpdateUserRoleRequest | UpdateUserRoleRequestJSON = updateUserRoleRequest;
    if (!this.writeCamelCase) {
      body = UpdateUserRoleRequestToJSON(updateUserRoleRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToMembership({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToMembership(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToMembership({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async listAllRoles(empty: Empty): Promise<TwirpResponse<ListAllRolesResponse>> {
    const url = `${this.hostname}${this.pathPrefix}ListAllRoles`;
    let body: Empty | EmptyJSON = empty;
    if (!this.writeCamelCase) {
      body = EmptyToJSON(empty);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToListAllRolesResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToListAllRolesResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToListAllRolesResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async validateByTwitchID(validateQuery: ValidateQuery): Promise<TwirpResponse<ValidateResponse>> {
    const url = `${this.hostname}${this.pathPrefix}ValidateByTwitchID`;
    let body: ValidateQuery | ValidateQueryJSON = validateQuery;
    if (!this.writeCamelCase) {
      body = ValidateQueryToJSON(validateQuery);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToValidateResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToValidateResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToValidateResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async createResource(
    createResourceRequest: CreateResourceRequest,
  ): Promise<TwirpResponse<CreateResourceResponse>> {
    const url = `${this.hostname}${this.pathPrefix}CreateResource`;
    let body: CreateResourceRequest | CreateResourceRequestJSON = createResourceRequest;
    if (!this.writeCamelCase) {
      body = CreateResourceRequestToJSON(createResourceRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToCreateResourceResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToCreateResourceResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToCreateResourceResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async listResources(
    listResourcesRequest: ListResourcesRequest,
  ): Promise<TwirpResponse<ListResourcesResponse>> {
    const url = `${this.hostname}${this.pathPrefix}ListResources`;
    let body: ListResourcesRequest | ListResourcesRequestJSON = listResourcesRequest;
    if (!this.writeCamelCase) {
      body = ListResourcesRequestToJSON(listResourcesRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToListResourcesResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToListResourcesResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToListResourcesResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async setExtensionBillingManager(
    setExtensionBillingManagerRequest: SetExtensionBillingManagerRequest,
  ): Promise<TwirpResponse<SetExtensionBillingManagerResponse>> {
    const url = `${this.hostname}${this.pathPrefix}SetExtensionBillingManager`;
    let body:
      | SetExtensionBillingManagerRequest
      | SetExtensionBillingManagerRequestJSON = setExtensionBillingManagerRequest;
    if (!this.writeCamelCase) {
      body = SetExtensionBillingManagerRequestToJSON(setExtensionBillingManagerRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToSetExtensionBillingManagerResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToSetExtensionBillingManagerResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToSetExtensionBillingManagerResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async getExtensionBillingManager(
    getExtensionBillingManagerRequest: GetExtensionBillingManagerRequest,
  ): Promise<TwirpResponse<GetExtensionBillingManagerResponse>> {
    const url = `${this.hostname}${this.pathPrefix}GetExtensionBillingManager`;
    let body:
      | GetExtensionBillingManagerRequest
      | GetExtensionBillingManagerRequestJSON = getExtensionBillingManagerRequest;
    if (!this.writeCamelCase) {
      body = GetExtensionBillingManagerRequestToJSON(getExtensionBillingManagerRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToGetExtensionBillingManagerResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToGetExtensionBillingManagerResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToGetExtensionBillingManagerResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async getPaginatedShadowAccounts(
    getPaginatedShadowAccountsRequest: GetPaginatedShadowAccountsRequest,
  ): Promise<TwirpResponse<GetPaginatedShadowAccountsResponse>> {
    const url = `${this.hostname}${this.pathPrefix}GetPaginatedShadowAccounts`;
    let body:
      | GetPaginatedShadowAccountsRequest
      | GetPaginatedShadowAccountsRequestJSON = getPaginatedShadowAccountsRequest;
    if (!this.writeCamelCase) {
      body = GetPaginatedShadowAccountsRequestToJSON(getPaginatedShadowAccountsRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToGetPaginatedShadowAccountsResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToGetPaginatedShadowAccountsResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToGetPaginatedShadowAccountsResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async transferExtensionToCompany(
    transferExtensionRequest: TransferExtensionRequest,
  ): Promise<TwirpResponse<Empty>> {
    const url = `${this.hostname}${this.pathPrefix}TransferExtensionToCompany`;
    let body: TransferExtensionRequest | TransferExtensionRequestJSON = transferExtensionRequest;
    if (!this.writeCamelCase) {
      body = TransferExtensionRequestToJSON(transferExtensionRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToEmpty({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToEmpty(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToEmpty({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async detachExtensionFromCompany(
    detachExtensionRequest: DetachExtensionRequest,
  ): Promise<TwirpResponse<Empty>> {
    const url = `${this.hostname}${this.pathPrefix}DetachExtensionFromCompany`;
    let body: DetachExtensionRequest | DetachExtensionRequestJSON = detachExtensionRequest;
    if (!this.writeCamelCase) {
      body = DetachExtensionRequestToJSON(detachExtensionRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToEmpty({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToEmpty(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToEmpty({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async listCompanyApplications(
    listCompanyApplicationsRequest: ListCompanyApplicationsRequest,
  ): Promise<TwirpResponse<ListCompanyApplicationsResponse>> {
    const url = `${this.hostname}${this.pathPrefix}ListCompanyApplications`;
    let body: ListCompanyApplicationsRequest | ListCompanyApplicationsRequestJSON = listCompanyApplicationsRequest;
    if (!this.writeCamelCase) {
      body = ListCompanyApplicationsRequestToJSON(listCompanyApplicationsRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToListCompanyApplicationsResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToListCompanyApplicationsResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToListCompanyApplicationsResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async searchCompanyApplications(
    searchCompanyApplicationsRequest: SearchCompanyApplicationsRequest,
  ): Promise<TwirpResponse<SearchCompanyApplicationsResponse>> {
    const url = `${this.hostname}${this.pathPrefix}SearchCompanyApplications`;
    let body:
      | SearchCompanyApplicationsRequest
      | SearchCompanyApplicationsRequestJSON = searchCompanyApplicationsRequest;
    if (!this.writeCamelCase) {
      body = SearchCompanyApplicationsRequestToJSON(searchCompanyApplicationsRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToSearchCompanyApplicationsResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToSearchCompanyApplicationsResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToSearchCompanyApplicationsResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async getCompanyApplication(id: Id): Promise<TwirpResponse<CompanyApplication>> {
    const url = `${this.hostname}${this.pathPrefix}GetCompanyApplication`;
    let body: Id | IdJSON = id;
    if (!this.writeCamelCase) {
      body = IdToJSON(id);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToCompanyApplication({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToCompanyApplication(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToCompanyApplication({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async updateCompanyApplication(
    updateCompanyApplicationRequest: UpdateCompanyApplicationRequest,
  ): Promise<TwirpResponse<CompanyApplication>> {
    const url = `${this.hostname}${this.pathPrefix}UpdateCompanyApplication`;
    let body: UpdateCompanyApplicationRequest | UpdateCompanyApplicationRequestJSON = updateCompanyApplicationRequest;
    if (!this.writeCamelCase) {
      body = UpdateCompanyApplicationRequestToJSON(updateCompanyApplicationRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToCompanyApplication({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToCompanyApplication(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToCompanyApplication({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async deleteCompanyApplication(
    deleteCompanyApplicationRequest: DeleteCompanyApplicationRequest,
  ): Promise<TwirpResponse<Empty>> {
    const url = `${this.hostname}${this.pathPrefix}DeleteCompanyApplication`;
    let body: DeleteCompanyApplicationRequest | DeleteCompanyApplicationRequestJSON = deleteCompanyApplicationRequest;
    if (!this.writeCamelCase) {
      body = DeleteCompanyApplicationRequestToJSON(deleteCompanyApplicationRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToEmpty({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToEmpty(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToEmpty({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async onboardCompany(
    onboardCompanyRequest: OnboardCompanyRequest,
  ): Promise<TwirpResponse<OnboardCompanyResponse>> {
    const url = `${this.hostname}${this.pathPrefix}OnboardCompany`;
    let body: OnboardCompanyRequest | OnboardCompanyRequestJSON = onboardCompanyRequest;
    if (!this.writeCamelCase) {
      body = OnboardCompanyRequestToJSON(onboardCompanyRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToOnboardCompanyResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToOnboardCompanyResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToOnboardCompanyResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async listGameApplications(
    listGameApplicationsRequest: ListGameApplicationsRequest,
  ): Promise<TwirpResponse<ListGameApplicationsResponse>> {
    const url = `${this.hostname}${this.pathPrefix}ListGameApplications`;
    let body: ListGameApplicationsRequest | ListGameApplicationsRequestJSON = listGameApplicationsRequest;
    if (!this.writeCamelCase) {
      body = ListGameApplicationsRequestToJSON(listGameApplicationsRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToListGameApplicationsResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToListGameApplicationsResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToListGameApplicationsResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async getGameApplicationsByCompany(id: Id): Promise<TwirpResponse<GetGameApplicationsByCompanyResponse>> {
    const url = `${this.hostname}${this.pathPrefix}GetGameApplicationsByCompany`;
    let body: Id | IdJSON = id;
    if (!this.writeCamelCase) {
      body = IdToJSON(id);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToGetGameApplicationsByCompanyResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToGetGameApplicationsByCompanyResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToGetGameApplicationsByCompanyResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async getGameApplication(id: Id): Promise<TwirpResponse<GameApplication>> {
    const url = `${this.hostname}${this.pathPrefix}GetGameApplication`;
    let body: Id | IdJSON = id;
    if (!this.writeCamelCase) {
      body = IdToJSON(id);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToGameApplication({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToGameApplication(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToGameApplication({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async createGameApplication(
    createGameApplicationRequest: CreateGameApplicationRequest,
  ): Promise<TwirpResponse<GameApplication>> {
    const url = `${this.hostname}${this.pathPrefix}CreateGameApplication`;
    let body: CreateGameApplicationRequest | CreateGameApplicationRequestJSON = createGameApplicationRequest;
    if (!this.writeCamelCase) {
      body = CreateGameApplicationRequestToJSON(createGameApplicationRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToGameApplication({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToGameApplication(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToGameApplication({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async createGameApplicationV2(
    createGameApplicationRequestV2: CreateGameApplicationRequestV2,
  ): Promise<TwirpResponse<GameApplication>> {
    const url = `${this.hostname}${this.pathPrefix}CreateGameApplicationV2`;
    let body: CreateGameApplicationRequestV2 | CreateGameApplicationRequestV2JSON = createGameApplicationRequestV2;
    if (!this.writeCamelCase) {
      body = CreateGameApplicationRequestV2ToJSON(createGameApplicationRequestV2);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToGameApplication({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToGameApplication(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToGameApplication({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async deleteGameApplication(
    deleteGameApplicationRequest: DeleteGameApplicationRequest,
  ): Promise<TwirpResponse<Empty>> {
    const url = `${this.hostname}${this.pathPrefix}DeleteGameApplication`;
    let body: DeleteGameApplicationRequest | DeleteGameApplicationRequestJSON = deleteGameApplicationRequest;
    if (!this.writeCamelCase) {
      body = DeleteGameApplicationRequestToJSON(deleteGameApplicationRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToEmpty({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToEmpty(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToEmpty({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async onboardGame(onboardGameRequest: OnboardGameRequest): Promise<TwirpResponse<OnboardGameResponse>> {
    const url = `${this.hostname}${this.pathPrefix}OnboardGame`;
    let body: OnboardGameRequest | OnboardGameRequestJSON = onboardGameRequest;
    if (!this.writeCamelCase) {
      body = OnboardGameRequestToJSON(onboardGameRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToOnboardGameResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToOnboardGameResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToOnboardGameResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async getDeveloperApplications(
    getDeveloperApplicationsRequest: GetDeveloperApplicationsRequest,
  ): Promise<TwirpResponse<GetDeveloperApplicationsResponse>> {
    const url = `${this.hostname}${this.pathPrefix}GetDeveloperApplications`;
    let body: GetDeveloperApplicationsRequest | GetDeveloperApplicationsRequestJSON = getDeveloperApplicationsRequest;
    if (!this.writeCamelCase) {
      body = GetDeveloperApplicationsRequestToJSON(getDeveloperApplicationsRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToGetDeveloperApplicationsResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToGetDeveloperApplicationsResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToGetDeveloperApplicationsResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async deleteDeveloperApplication(
    deleteDeveloperApplicationRequest: DeleteDeveloperApplicationRequest,
  ): Promise<TwirpResponse<Empty>> {
    const url = `${this.hostname}${this.pathPrefix}DeleteDeveloperApplication`;
    let body:
      | DeleteDeveloperApplicationRequest
      | DeleteDeveloperApplicationRequestJSON = deleteDeveloperApplicationRequest;
    if (!this.writeCamelCase) {
      body = DeleteDeveloperApplicationRequestToJSON(deleteDeveloperApplicationRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToEmpty({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToEmpty(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToEmpty({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async onboardDeveloper(
    onboardDeveloperRequest: OnboardDeveloperRequest,
  ): Promise<TwirpResponse<OnboardDeveloperResponse>> {
    const url = `${this.hostname}${this.pathPrefix}OnboardDeveloper`;
    let body: OnboardDeveloperRequest | OnboardDeveloperRequestJSON = onboardDeveloperRequest;
    if (!this.writeCamelCase) {
      body = OnboardDeveloperRequestToJSON(onboardDeveloperRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToOnboardDeveloperResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToOnboardDeveloperResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToOnboardDeveloperResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async getGamesByCompany(id: Id): Promise<TwirpResponse<GetGamesByCompanyResponse>> {
    const url = `${this.hostname}${this.pathPrefix}GetGamesByCompany`;
    let body: Id | IdJSON = id;
    if (!this.writeCamelCase) {
      body = IdToJSON(id);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToGetGamesByCompanyResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToGetGamesByCompanyResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToGetGamesByCompanyResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async getGamesByTwitchID(id: Id): Promise<TwirpResponse<GetGamesByTwitchIDResponse>> {
    const url = `${this.hostname}${this.pathPrefix}GetGamesByTwitchID`;
    let body: Id | IdJSON = id;
    if (!this.writeCamelCase) {
      body = IdToJSON(id);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToGetGamesByTwitchIDResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToGetGamesByTwitchIDResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToGetGamesByTwitchIDResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async getCompanyByTwitchID(id: Id): Promise<TwirpResponse<Company>> {
    const url = `${this.hostname}${this.pathPrefix}GetCompanyByTwitchID`;
    let body: Id | IdJSON = id;
    if (!this.writeCamelCase) {
      body = IdToJSON(id);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToCompany({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToCompany(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToCompany({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async createJWT(jWTRequest: JWTRequest): Promise<TwirpResponse<JWT>> {
    const url = `${this.hostname}${this.pathPrefix}CreateJWT`;
    let body: JWTRequest | JWTRequestJSON = jWTRequest;
    if (!this.writeCamelCase) {
      body = JWTRequestToJSON(jWTRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToJWT({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToJWT(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToJWT({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async getAllGamesWithCompanies(
    getAllGamesWithCompaniesRequest: GetAllGamesWithCompaniesRequest,
  ): Promise<TwirpResponse<GetAllGamesWithCompaniesResponse>> {
    const url = `${this.hostname}${this.pathPrefix}GetAllGamesWithCompanies`;
    let body: GetAllGamesWithCompaniesRequest | GetAllGamesWithCompaniesRequestJSON = getAllGamesWithCompaniesRequest;
    if (!this.writeCamelCase) {
      body = GetAllGamesWithCompaniesRequestToJSON(getAllGamesWithCompaniesRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToGetAllGamesWithCompaniesResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToGetAllGamesWithCompaniesResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToGetAllGamesWithCompaniesResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async isFeatureEnabled(
    isFeatureEnabledRequest: IsFeatureEnabledRequest,
  ): Promise<TwirpResponse<FeatureEnabledResponse>> {
    const url = `${this.hostname}${this.pathPrefix}IsFeatureEnabled`;
    let body: IsFeatureEnabledRequest | IsFeatureEnabledRequestJSON = isFeatureEnabledRequest;
    if (!this.writeCamelCase) {
      body = IsFeatureEnabledRequestToJSON(isFeatureEnabledRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToFeatureEnabledResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToFeatureEnabledResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToFeatureEnabledResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async isValueEnabled(
    isValueEnabledRequest: IsValueEnabledRequest,
  ): Promise<TwirpResponse<FeatureEnabledResponse>> {
    const url = `${this.hostname}${this.pathPrefix}IsValueEnabled`;
    let body: IsValueEnabledRequest | IsValueEnabledRequestJSON = isValueEnabledRequest;
    if (!this.writeCamelCase) {
      body = IsValueEnabledRequestToJSON(isValueEnabledRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToFeatureEnabledResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToFeatureEnabledResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToFeatureEnabledResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }
}

export interface RBACAdmin {
  deleteCompany: (deleteCompanyRequest: DeleteCompanyRequest) => Promise<TwirpResponse<Empty>>;

  offboardResource: (offboardResourceRequest: OffboardResourceRequest) => Promise<TwirpResponse<Empty>>;

  transferCompanyOwnership: (
    transferCompanyOwnershipRequest: TransferCompanyOwnershipRequest,
  ) => Promise<TwirpResponse<Empty>>;

  whitelistUser: (whitelistUserRequest: WhitelistUserRequest) => Promise<TwirpResponse<Empty>>;

  removeUserFromWhitelist: (
    removeUserFromWhitelistRequest: RemoveUserFromWhitelistRequest,
  ) => Promise<TwirpResponse<Empty>>;

  updateUserRoleInWhitelist: (whitelistUserRequest: WhitelistUserRequest) => Promise<TwirpResponse<Empty>>;

  listUserWhitelistByRole: (
    listUserWhitelistByRoleRequest: ListUserWhitelistByRoleRequest,
  ) => Promise<TwirpResponse<ListUserWhitelistByRoleResponse>>;

  getFeatureGatingValueInBool: (
    getFeatureGatingValueRequest: GetFeatureGatingValueRequest,
  ) => Promise<TwirpResponse<GetFeatureGatingValueResponse>>;

  setFeatureGatingBoolValue: (
    setFeatureGatingBoolValueRequest: SetFeatureGatingBoolValueRequest,
  ) => Promise<TwirpResponse<Empty>>;

  getFeatureGatingValueInStrings: (
    getFeatureGatingValueRequest: GetFeatureGatingValueRequest,
  ) => Promise<TwirpResponse<GetFeatureGatingValueResponse>>;

  updateFeatureGatingValue: (
    updateFeatureGatingValueRequest: UpdateFeatureGatingValueRequest,
  ) => Promise<TwirpResponse<GetFeatureGatingValueResponse>>;

  createShadowAccount: (
    createShadowAccountRequest: CreateShadowAccountRequest,
  ) => Promise<TwirpResponse<CreateShadowAccountResponse>>;
}

// tslint:disable-next-line:max-classes-per-file
export class DefaultRBACAdmin implements RBACAdmin {
  private hostname: string;
  private fetch: Fetch;
  private writeCamelCase: boolean;
  private pathPrefix = '/twirp/code.justin.tv.devrel.rbac.RBACAdmin/';

  constructor(hostname: string, fetch: Fetch, writeCamelCase = false) {
    this.hostname = hostname;
    this.fetch = fetch;
    this.writeCamelCase = writeCamelCase;
  }
  public async deleteCompany(deleteCompanyRequest: DeleteCompanyRequest): Promise<TwirpResponse<Empty>> {
    const url = `${this.hostname}${this.pathPrefix}DeleteCompany`;
    let body: DeleteCompanyRequest | DeleteCompanyRequestJSON = deleteCompanyRequest;
    if (!this.writeCamelCase) {
      body = DeleteCompanyRequestToJSON(deleteCompanyRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToEmpty({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToEmpty(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToEmpty({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async offboardResource(offboardResourceRequest: OffboardResourceRequest): Promise<TwirpResponse<Empty>> {
    const url = `${this.hostname}${this.pathPrefix}OffboardResource`;
    let body: OffboardResourceRequest | OffboardResourceRequestJSON = offboardResourceRequest;
    if (!this.writeCamelCase) {
      body = OffboardResourceRequestToJSON(offboardResourceRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToEmpty({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToEmpty(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToEmpty({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async transferCompanyOwnership(
    transferCompanyOwnershipRequest: TransferCompanyOwnershipRequest,
  ): Promise<TwirpResponse<Empty>> {
    const url = `${this.hostname}${this.pathPrefix}TransferCompanyOwnership`;
    let body: TransferCompanyOwnershipRequest | TransferCompanyOwnershipRequestJSON = transferCompanyOwnershipRequest;
    if (!this.writeCamelCase) {
      body = TransferCompanyOwnershipRequestToJSON(transferCompanyOwnershipRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToEmpty({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToEmpty(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToEmpty({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async whitelistUser(whitelistUserRequest: WhitelistUserRequest): Promise<TwirpResponse<Empty>> {
    const url = `${this.hostname}${this.pathPrefix}WhitelistUser`;
    let body: WhitelistUserRequest | WhitelistUserRequestJSON = whitelistUserRequest;
    if (!this.writeCamelCase) {
      body = WhitelistUserRequestToJSON(whitelistUserRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToEmpty({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToEmpty(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToEmpty({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async removeUserFromWhitelist(
    removeUserFromWhitelistRequest: RemoveUserFromWhitelistRequest,
  ): Promise<TwirpResponse<Empty>> {
    const url = `${this.hostname}${this.pathPrefix}RemoveUserFromWhitelist`;
    let body: RemoveUserFromWhitelistRequest | RemoveUserFromWhitelistRequestJSON = removeUserFromWhitelistRequest;
    if (!this.writeCamelCase) {
      body = RemoveUserFromWhitelistRequestToJSON(removeUserFromWhitelistRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToEmpty({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToEmpty(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToEmpty({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async updateUserRoleInWhitelist(whitelistUserRequest: WhitelistUserRequest): Promise<TwirpResponse<Empty>> {
    const url = `${this.hostname}${this.pathPrefix}UpdateUserRoleInWhitelist`;
    let body: WhitelistUserRequest | WhitelistUserRequestJSON = whitelistUserRequest;
    if (!this.writeCamelCase) {
      body = WhitelistUserRequestToJSON(whitelistUserRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToEmpty({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToEmpty(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToEmpty({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async listUserWhitelistByRole(
    listUserWhitelistByRoleRequest: ListUserWhitelistByRoleRequest,
  ): Promise<TwirpResponse<ListUserWhitelistByRoleResponse>> {
    const url = `${this.hostname}${this.pathPrefix}ListUserWhitelistByRole`;
    let body: ListUserWhitelistByRoleRequest | ListUserWhitelistByRoleRequestJSON = listUserWhitelistByRoleRequest;
    if (!this.writeCamelCase) {
      body = ListUserWhitelistByRoleRequestToJSON(listUserWhitelistByRoleRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToListUserWhitelistByRoleResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToListUserWhitelistByRoleResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToListUserWhitelistByRoleResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async getFeatureGatingValueInBool(
    getFeatureGatingValueRequest: GetFeatureGatingValueRequest,
  ): Promise<TwirpResponse<GetFeatureGatingValueResponse>> {
    const url = `${this.hostname}${this.pathPrefix}GetFeatureGatingValueInBool`;
    let body: GetFeatureGatingValueRequest | GetFeatureGatingValueRequestJSON = getFeatureGatingValueRequest;
    if (!this.writeCamelCase) {
      body = GetFeatureGatingValueRequestToJSON(getFeatureGatingValueRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToGetFeatureGatingValueResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToGetFeatureGatingValueResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToGetFeatureGatingValueResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async setFeatureGatingBoolValue(
    setFeatureGatingBoolValueRequest: SetFeatureGatingBoolValueRequest,
  ): Promise<TwirpResponse<Empty>> {
    const url = `${this.hostname}${this.pathPrefix}SetFeatureGatingBoolValue`;
    let body:
      | SetFeatureGatingBoolValueRequest
      | SetFeatureGatingBoolValueRequestJSON = setFeatureGatingBoolValueRequest;
    if (!this.writeCamelCase) {
      body = SetFeatureGatingBoolValueRequestToJSON(setFeatureGatingBoolValueRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToEmpty({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToEmpty(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToEmpty({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async getFeatureGatingValueInStrings(
    getFeatureGatingValueRequest: GetFeatureGatingValueRequest,
  ): Promise<TwirpResponse<GetFeatureGatingValueResponse>> {
    const url = `${this.hostname}${this.pathPrefix}GetFeatureGatingValueInStrings`;
    let body: GetFeatureGatingValueRequest | GetFeatureGatingValueRequestJSON = getFeatureGatingValueRequest;
    if (!this.writeCamelCase) {
      body = GetFeatureGatingValueRequestToJSON(getFeatureGatingValueRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToGetFeatureGatingValueResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToGetFeatureGatingValueResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToGetFeatureGatingValueResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async updateFeatureGatingValue(
    updateFeatureGatingValueRequest: UpdateFeatureGatingValueRequest,
  ): Promise<TwirpResponse<GetFeatureGatingValueResponse>> {
    const url = `${this.hostname}${this.pathPrefix}UpdateFeatureGatingValue`;
    let body: UpdateFeatureGatingValueRequest | UpdateFeatureGatingValueRequestJSON = updateFeatureGatingValueRequest;
    if (!this.writeCamelCase) {
      body = UpdateFeatureGatingValueRequestToJSON(updateFeatureGatingValueRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToGetFeatureGatingValueResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToGetFeatureGatingValueResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToGetFeatureGatingValueResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async createShadowAccount(
    createShadowAccountRequest: CreateShadowAccountRequest,
  ): Promise<TwirpResponse<CreateShadowAccountResponse>> {
    const url = `${this.hostname}${this.pathPrefix}CreateShadowAccount`;
    let body: CreateShadowAccountRequest | CreateShadowAccountRequestJSON = createShadowAccountRequest;
    if (!this.writeCamelCase) {
      body = CreateShadowAccountRequestToJSON(createShadowAccountRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToCreateShadowAccountResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToCreateShadowAccountResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToCreateShadowAccountResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }
}

export interface RBACActionHistory {
  listEntityActionHistories: (
    listEntityActionHistoriesRequest: ListEntityActionHistoriesRequest,
  ) => Promise<TwirpResponse<ListActionHistoriesResponse>>;

  listActionHistories: (
    listActionHistoriesRequest: ListActionHistoriesRequest,
  ) => Promise<TwirpResponse<ListActionHistoriesResponse>>;
}

// tslint:disable-next-line:max-classes-per-file
export class DefaultRBACActionHistory implements RBACActionHistory {
  private hostname: string;
  private fetch: Fetch;
  private writeCamelCase: boolean;
  private pathPrefix = '/twirp/code.justin.tv.devrel.rbac.RBACActionHistory/';

  constructor(hostname: string, fetch: Fetch, writeCamelCase = false) {
    this.hostname = hostname;
    this.fetch = fetch;
    this.writeCamelCase = writeCamelCase;
  }
  public async listEntityActionHistories(
    listEntityActionHistoriesRequest: ListEntityActionHistoriesRequest,
  ): Promise<TwirpResponse<ListActionHistoriesResponse>> {
    const url = `${this.hostname}${this.pathPrefix}ListEntityActionHistories`;
    let body:
      | ListEntityActionHistoriesRequest
      | ListEntityActionHistoriesRequestJSON = listEntityActionHistoriesRequest;
    if (!this.writeCamelCase) {
      body = ListEntityActionHistoriesRequestToJSON(listEntityActionHistoriesRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToListActionHistoriesResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToListActionHistoriesResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToListActionHistoriesResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async listActionHistories(
    listActionHistoriesRequest: ListActionHistoriesRequest,
  ): Promise<TwirpResponse<ListActionHistoriesResponse>> {
    const url = `${this.hostname}${this.pathPrefix}ListActionHistories`;
    let body: ListActionHistoriesRequest | ListActionHistoriesRequestJSON = listActionHistoriesRequest;
    if (!this.writeCamelCase) {
      body = ListActionHistoriesRequestToJSON(listActionHistoriesRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToListActionHistoriesResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToListActionHistoriesResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToListActionHistoriesResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }
}

export interface ExtensionReviews {
  setStateInReview: (setStateInReviewRequest: SetStateInReviewRequest) => Promise<TwirpResponse<Empty>>;

  getLatestAuthorNotes: (
    getLatestAuthorNotesRequest: GetLatestAuthorNotesRequest,
  ) => Promise<TwirpResponse<GetLatestAuthorNotesResponse>>;

  getExtension: (extensionVersionID: ExtensionVersionID) => Promise<TwirpResponse<Extension>>;

  setStateApproved: (setStateReviewerRequest: SetStateReviewerRequest) => Promise<TwirpResponse<Empty>>;

  setStatePendingAction: (setStateReviewerRequest: SetStateReviewerRequest) => Promise<TwirpResponse<Empty>>;
}

// tslint:disable-next-line:max-classes-per-file
export class DefaultExtensionReviews implements ExtensionReviews {
  private hostname: string;
  private fetch: Fetch;
  private writeCamelCase: boolean;
  private pathPrefix = '/twirp/code.justin.tv.devrel.rbac.ExtensionReviews/';

  constructor(hostname: string, fetch: Fetch, writeCamelCase = false) {
    this.hostname = hostname;
    this.fetch = fetch;
    this.writeCamelCase = writeCamelCase;
  }
  public async setStateInReview(setStateInReviewRequest: SetStateInReviewRequest): Promise<TwirpResponse<Empty>> {
    const url = `${this.hostname}${this.pathPrefix}SetStateInReview`;
    let body: SetStateInReviewRequest | SetStateInReviewRequestJSON = setStateInReviewRequest;
    if (!this.writeCamelCase) {
      body = SetStateInReviewRequestToJSON(setStateInReviewRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToEmpty({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToEmpty(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToEmpty({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async getLatestAuthorNotes(
    getLatestAuthorNotesRequest: GetLatestAuthorNotesRequest,
  ): Promise<TwirpResponse<GetLatestAuthorNotesResponse>> {
    const url = `${this.hostname}${this.pathPrefix}GetLatestAuthorNotes`;
    let body: GetLatestAuthorNotesRequest | GetLatestAuthorNotesRequestJSON = getLatestAuthorNotesRequest;
    if (!this.writeCamelCase) {
      body = GetLatestAuthorNotesRequestToJSON(getLatestAuthorNotesRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToGetLatestAuthorNotesResponse({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToGetLatestAuthorNotesResponse(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToGetLatestAuthorNotesResponse({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async getExtension(extensionVersionID: ExtensionVersionID): Promise<TwirpResponse<Extension>> {
    const url = `${this.hostname}${this.pathPrefix}GetExtension`;
    let body: ExtensionVersionID | ExtensionVersionIDJSON = extensionVersionID;
    if (!this.writeCamelCase) {
      body = ExtensionVersionIDToJSON(extensionVersionID);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToExtension({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToExtension(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToExtension({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async setStateApproved(setStateReviewerRequest: SetStateReviewerRequest): Promise<TwirpResponse<Empty>> {
    const url = `${this.hostname}${this.pathPrefix}SetStateApproved`;
    let body: SetStateReviewerRequest | SetStateReviewerRequestJSON = setStateReviewerRequest;
    if (!this.writeCamelCase) {
      body = SetStateReviewerRequestToJSON(setStateReviewerRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToEmpty({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToEmpty(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToEmpty({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }

  public async setStatePendingAction(setStateReviewerRequest: SetStateReviewerRequest): Promise<TwirpResponse<Empty>> {
    const url = `${this.hostname}${this.pathPrefix}SetStatePendingAction`;
    let body: SetStateReviewerRequest | SetStateReviewerRequestJSON = setStateReviewerRequest;
    if (!this.writeCamelCase) {
      body = SetStateReviewerRequestToJSON(setStateReviewerRequest);
    }
    try {
      const resp = await this.fetch(createTwirpRequest(url, body));
      if (!resp.ok) {
        return {
          // tslint:disable-next-line:no-any
          data: JSONToEmpty({} as any),
          error: new TwirpError(await resp.json()),
        };
      }

      return {
        data: JSONToEmpty(await resp.json()),
      };
    } catch (error) {
      return {
        // tslint:disable-next-line:no-any
        data: JSONToEmpty({} as any),
        error: new TwirpError({ msg: error.message, code: 'internal', meta: {} }),
      };
    }
  }
}
