import {
  AddUserToCompanyRequest,
  Company,
  CompanyApplication,
  CreateCompanyApplicationRequest,
  CreateGameApplicationRequest,
  CreateGameApplicationRequestV2,
  CreateResourceRequest,
  CreateResourceResponse,
  CreateShadowAccountRequest,
  CreateShadowAccountResponse,
  DeleteCompanyApplicationRequest,
  DeleteCompanyRequest,
  DeleteDeveloperApplicationRequest,
  DeleteGameApplicationRequest,
  DetachExtensionRequest,
  Empty,
  Extension,
  ExtensionReviews,
  ExtensionVersionID,
  FeatureEnabledResponse,
  GameApplication,
  GetAllGamesWithCompaniesRequest,
  GetAllGamesWithCompaniesResponse,
  GetDeveloperApplicationsRequest,
  GetDeveloperApplicationsResponse,
  GetExtensionBillingManagerRequest,
  GetExtensionBillingManagerResponse,
  GetFeatureGatingValueRequest,
  GetFeatureGatingValueResponse,
  GetGameApplicationsByCompanyResponse,
  GetGamesByCompanyResponse,
  GetGamesByTwitchIDResponse,
  GetLatestAuthorNotesRequest,
  GetLatestAuthorNotesResponse,
  GetMembershipRequest,
  GetPaginatedShadowAccountsRequest,
  GetPaginatedShadowAccountsResponse,
  GetUsersByCompanyIdRequest,
  GetUsersByCompanyIdResponse,
  Id,
  IsFeatureEnabledRequest,
  IsValueEnabledRequest,
  JWT,
  JWTRequest,
  ListActionHistoriesRequest,
  ListActionHistoriesResponse,
  ListAllRolesResponse,
  ListCompaniesRequest,
  ListCompaniesResponse,
  ListCompanyApplicationsRequest,
  ListCompanyApplicationsResponse,
  ListCompanyMembershipsRequest,
  ListCompanyMembershipsResponse,
  ListEntityActionHistoriesRequest,
  ListGameApplicationsRequest,
  ListGameApplicationsResponse,
  ListResourcesRequest,
  ListResourcesResponse,
  ListUserWhitelistByRoleRequest,
  ListUserWhitelistByRoleResponse,
  Membership,
  OffboardResourceRequest,
  OnboardCompanyRequest,
  OnboardCompanyResponse,
  OnboardDeveloperRequest,
  OnboardDeveloperResponse,
  OnboardGameRequest,
  OnboardGameResponse,
  RBAC,
  RBACActionHistory,
  RBACAdmin,
  RemoveCompanyMembershipRequest,
  RemoveUserFromWhitelistRequest,
  SearchCompaniesRequest,
  SearchCompaniesResponse,
  SearchCompanyApplicationsRequest,
  SearchCompanyApplicationsResponse,
  SetExtensionBillingManagerRequest,
  SetExtensionBillingManagerResponse,
  SetFeatureGatingBoolValueRequest,
  SetStateInReviewRequest,
  SetStateReviewerRequest,
  TransferCompanyOwnershipRequest,
  TransferExtensionRequest,
  UpdateCompanyApplicationRequest,
  UpdateCompanyRequest,
  UpdateFeatureGatingValueRequest,
  UpdateUserRequest,
  UpdateUserRoleRequest,
  ValidateQuery,
  ValidateResponse,
  WhitelistUserRequest,
} from './rbacrpc';
import { TwirpResponse } from './twirp';

export class RBACMock implements RBAC {
  public listCompaniesMock: jest.Mock<TwirpResponse<ListCompaniesResponse>>;
  public listCompanyMembershipsMock: jest.Mock<TwirpResponse<ListCompanyMembershipsResponse>>;
  public searchCompaniesMock: jest.Mock<TwirpResponse<SearchCompaniesResponse>>;
  public getCompanyMock: jest.Mock<TwirpResponse<Company>>;
  public updateCompanyMock: jest.Mock<TwirpResponse<Company>>;
  public createCompanyApplicationMock: jest.Mock<TwirpResponse<CompanyApplication>>;
  public getMembershipMock: jest.Mock<TwirpResponse<Membership>>;
  public getUsersByCompanyIdMock: jest.Mock<TwirpResponse<GetUsersByCompanyIdResponse>>;
  public addUserToCompanyMock: jest.Mock<TwirpResponse<Empty>>;
  public removeCompanyMembershipMock: jest.Mock<TwirpResponse<Empty>>;
  public updateUserMock: jest.Mock<TwirpResponse<Empty>>;
  public updateUserRoleMock: jest.Mock<TwirpResponse<Membership>>;
  public listAllRolesMock: jest.Mock<TwirpResponse<ListAllRolesResponse>>;
  public validateByTwitchIDMock: jest.Mock<TwirpResponse<ValidateResponse>>;
  public createResourceMock: jest.Mock<TwirpResponse<CreateResourceResponse>>;
  public listResourcesMock: jest.Mock<TwirpResponse<ListResourcesResponse>>;
  public setExtensionBillingManagerMock: jest.Mock<TwirpResponse<SetExtensionBillingManagerResponse>>;
  public getExtensionBillingManagerMock: jest.Mock<TwirpResponse<GetExtensionBillingManagerResponse>>;
  public getPaginatedShadowAccountsMock: jest.Mock<TwirpResponse<GetPaginatedShadowAccountsResponse>>;
  public transferExtensionToCompanyMock: jest.Mock<TwirpResponse<Empty>>;
  public detachExtensionFromCompanyMock: jest.Mock<TwirpResponse<Empty>>;
  public listCompanyApplicationsMock: jest.Mock<TwirpResponse<ListCompanyApplicationsResponse>>;
  public searchCompanyApplicationsMock: jest.Mock<TwirpResponse<SearchCompanyApplicationsResponse>>;
  public getCompanyApplicationMock: jest.Mock<TwirpResponse<CompanyApplication>>;
  public updateCompanyApplicationMock: jest.Mock<TwirpResponse<CompanyApplication>>;
  public deleteCompanyApplicationMock: jest.Mock<TwirpResponse<Empty>>;
  public onboardCompanyMock: jest.Mock<TwirpResponse<OnboardCompanyResponse>>;
  public listGameApplicationsMock: jest.Mock<TwirpResponse<ListGameApplicationsResponse>>;
  public getGameApplicationsByCompanyMock: jest.Mock<TwirpResponse<GetGameApplicationsByCompanyResponse>>;
  public getGameApplicationMock: jest.Mock<TwirpResponse<GameApplication>>;
  public createGameApplicationMock: jest.Mock<TwirpResponse<GameApplication>>;
  public createGameApplicationV2Mock: jest.Mock<TwirpResponse<GameApplication>>;
  public deleteGameApplicationMock: jest.Mock<TwirpResponse<Empty>>;
  public onboardGameMock: jest.Mock<TwirpResponse<OnboardGameResponse>>;
  public getDeveloperApplicationsMock: jest.Mock<TwirpResponse<GetDeveloperApplicationsResponse>>;
  public deleteDeveloperApplicationMock: jest.Mock<TwirpResponse<Empty>>;
  public onboardDeveloperMock: jest.Mock<TwirpResponse<OnboardDeveloperResponse>>;
  public getGamesByCompanyMock: jest.Mock<TwirpResponse<GetGamesByCompanyResponse>>;
  public getGamesByTwitchIDMock: jest.Mock<TwirpResponse<GetGamesByTwitchIDResponse>>;
  public getCompanyByTwitchIDMock: jest.Mock<TwirpResponse<Company>>;
  public createJWTMock: jest.Mock<TwirpResponse<JWT>>;
  public getAllGamesWithCompaniesMock: jest.Mock<TwirpResponse<GetAllGamesWithCompaniesResponse>>;
  public isFeatureEnabledMock: jest.Mock<TwirpResponse<FeatureEnabledResponse>>;
  public isValueEnabledMock: jest.Mock<TwirpResponse<FeatureEnabledResponse>>;

  public constructor() {
    this.listCompaniesMock = jest.fn();
    this.listCompanyMembershipsMock = jest.fn();
    this.searchCompaniesMock = jest.fn();
    this.getCompanyMock = jest.fn();
    this.updateCompanyMock = jest.fn();
    this.createCompanyApplicationMock = jest.fn();
    this.getMembershipMock = jest.fn();
    this.getUsersByCompanyIdMock = jest.fn();
    this.addUserToCompanyMock = jest.fn();
    this.removeCompanyMembershipMock = jest.fn();
    this.updateUserMock = jest.fn();
    this.updateUserRoleMock = jest.fn();
    this.listAllRolesMock = jest.fn();
    this.validateByTwitchIDMock = jest.fn();
    this.createResourceMock = jest.fn();
    this.listResourcesMock = jest.fn();
    this.setExtensionBillingManagerMock = jest.fn();
    this.getExtensionBillingManagerMock = jest.fn();
    this.getPaginatedShadowAccountsMock = jest.fn();
    this.transferExtensionToCompanyMock = jest.fn();
    this.detachExtensionFromCompanyMock = jest.fn();
    this.listCompanyApplicationsMock = jest.fn();
    this.searchCompanyApplicationsMock = jest.fn();
    this.getCompanyApplicationMock = jest.fn();
    this.updateCompanyApplicationMock = jest.fn();
    this.deleteCompanyApplicationMock = jest.fn();
    this.onboardCompanyMock = jest.fn();
    this.listGameApplicationsMock = jest.fn();
    this.getGameApplicationsByCompanyMock = jest.fn();
    this.getGameApplicationMock = jest.fn();
    this.createGameApplicationMock = jest.fn();
    this.createGameApplicationV2Mock = jest.fn();
    this.deleteGameApplicationMock = jest.fn();
    this.onboardGameMock = jest.fn();
    this.getDeveloperApplicationsMock = jest.fn();
    this.deleteDeveloperApplicationMock = jest.fn();
    this.onboardDeveloperMock = jest.fn();
    this.getGamesByCompanyMock = jest.fn();
    this.getGamesByTwitchIDMock = jest.fn();
    this.getCompanyByTwitchIDMock = jest.fn();
    this.createJWTMock = jest.fn();
    this.getAllGamesWithCompaniesMock = jest.fn();
    this.isFeatureEnabledMock = jest.fn();
    this.isValueEnabledMock = jest.fn();
  }
  public listCompanies(listCompaniesRequest: ListCompaniesRequest): Promise<TwirpResponse<ListCompaniesResponse>> {
    return Promise.resolve(this.listCompaniesMock(listCompaniesRequest));
  }
  public listCompanyMemberships(
    listCompanyMembershipsRequest: ListCompanyMembershipsRequest,
  ): Promise<TwirpResponse<ListCompanyMembershipsResponse>> {
    return Promise.resolve(this.listCompanyMembershipsMock(listCompanyMembershipsRequest));
  }
  public searchCompanies(
    searchCompaniesRequest: SearchCompaniesRequest,
  ): Promise<TwirpResponse<SearchCompaniesResponse>> {
    return Promise.resolve(this.searchCompaniesMock(searchCompaniesRequest));
  }
  public getCompany(id: Id): Promise<TwirpResponse<Company>> {
    return Promise.resolve(this.getCompanyMock(id));
  }
  public updateCompany(updateCompanyRequest: UpdateCompanyRequest): Promise<TwirpResponse<Company>> {
    return Promise.resolve(this.updateCompanyMock(updateCompanyRequest));
  }
  public createCompanyApplication(
    createCompanyApplicationRequest: CreateCompanyApplicationRequest,
  ): Promise<TwirpResponse<CompanyApplication>> {
    return Promise.resolve(this.createCompanyApplicationMock(createCompanyApplicationRequest));
  }
  public getMembership(getMembershipRequest: GetMembershipRequest): Promise<TwirpResponse<Membership>> {
    return Promise.resolve(this.getMembershipMock(getMembershipRequest));
  }
  public getUsersByCompanyId(
    getUsersByCompanyIdRequest: GetUsersByCompanyIdRequest,
  ): Promise<TwirpResponse<GetUsersByCompanyIdResponse>> {
    return Promise.resolve(this.getUsersByCompanyIdMock(getUsersByCompanyIdRequest));
  }
  public addUserToCompany(addUserToCompanyRequest: AddUserToCompanyRequest): Promise<TwirpResponse<Empty>> {
    return Promise.resolve(this.addUserToCompanyMock(addUserToCompanyRequest));
  }
  public removeCompanyMembership(
    removeCompanyMembershipRequest: RemoveCompanyMembershipRequest,
  ): Promise<TwirpResponse<Empty>> {
    return Promise.resolve(this.removeCompanyMembershipMock(removeCompanyMembershipRequest));
  }
  public updateUser(updateUserRequest: UpdateUserRequest): Promise<TwirpResponse<Empty>> {
    return Promise.resolve(this.updateUserMock(updateUserRequest));
  }
  public updateUserRole(updateUserRoleRequest: UpdateUserRoleRequest): Promise<TwirpResponse<Membership>> {
    return Promise.resolve(this.updateUserRoleMock(updateUserRoleRequest));
  }
  public listAllRoles(empty: Empty): Promise<TwirpResponse<ListAllRolesResponse>> {
    return Promise.resolve(this.listAllRolesMock(empty));
  }
  public validateByTwitchID(validateQuery: ValidateQuery): Promise<TwirpResponse<ValidateResponse>> {
    return Promise.resolve(this.validateByTwitchIDMock(validateQuery));
  }
  public createResource(createResourceRequest: CreateResourceRequest): Promise<TwirpResponse<CreateResourceResponse>> {
    return Promise.resolve(this.createResourceMock(createResourceRequest));
  }
  public listResources(listResourcesRequest: ListResourcesRequest): Promise<TwirpResponse<ListResourcesResponse>> {
    return Promise.resolve(this.listResourcesMock(listResourcesRequest));
  }
  public setExtensionBillingManager(
    setExtensionBillingManagerRequest: SetExtensionBillingManagerRequest,
  ): Promise<TwirpResponse<SetExtensionBillingManagerResponse>> {
    return Promise.resolve(this.setExtensionBillingManagerMock(setExtensionBillingManagerRequest));
  }
  public getExtensionBillingManager(
    getExtensionBillingManagerRequest: GetExtensionBillingManagerRequest,
  ): Promise<TwirpResponse<GetExtensionBillingManagerResponse>> {
    return Promise.resolve(this.getExtensionBillingManagerMock(getExtensionBillingManagerRequest));
  }
  public getPaginatedShadowAccounts(
    getPaginatedShadowAccountsRequest: GetPaginatedShadowAccountsRequest,
  ): Promise<TwirpResponse<GetPaginatedShadowAccountsResponse>> {
    return Promise.resolve(this.getPaginatedShadowAccountsMock(getPaginatedShadowAccountsRequest));
  }
  public transferExtensionToCompany(transferExtensionRequest: TransferExtensionRequest): Promise<TwirpResponse<Empty>> {
    return Promise.resolve(this.transferExtensionToCompanyMock(transferExtensionRequest));
  }
  public detachExtensionFromCompany(detachExtensionRequest: DetachExtensionRequest): Promise<TwirpResponse<Empty>> {
    return Promise.resolve(this.detachExtensionFromCompanyMock(detachExtensionRequest));
  }
  public listCompanyApplications(
    listCompanyApplicationsRequest: ListCompanyApplicationsRequest,
  ): Promise<TwirpResponse<ListCompanyApplicationsResponse>> {
    return Promise.resolve(this.listCompanyApplicationsMock(listCompanyApplicationsRequest));
  }
  public searchCompanyApplications(
    searchCompanyApplicationsRequest: SearchCompanyApplicationsRequest,
  ): Promise<TwirpResponse<SearchCompanyApplicationsResponse>> {
    return Promise.resolve(this.searchCompanyApplicationsMock(searchCompanyApplicationsRequest));
  }
  public getCompanyApplication(id: Id): Promise<TwirpResponse<CompanyApplication>> {
    return Promise.resolve(this.getCompanyApplicationMock(id));
  }
  public updateCompanyApplication(
    updateCompanyApplicationRequest: UpdateCompanyApplicationRequest,
  ): Promise<TwirpResponse<CompanyApplication>> {
    return Promise.resolve(this.updateCompanyApplicationMock(updateCompanyApplicationRequest));
  }
  public deleteCompanyApplication(
    deleteCompanyApplicationRequest: DeleteCompanyApplicationRequest,
  ): Promise<TwirpResponse<Empty>> {
    return Promise.resolve(this.deleteCompanyApplicationMock(deleteCompanyApplicationRequest));
  }
  public onboardCompany(onboardCompanyRequest: OnboardCompanyRequest): Promise<TwirpResponse<OnboardCompanyResponse>> {
    return Promise.resolve(this.onboardCompanyMock(onboardCompanyRequest));
  }
  public listGameApplications(
    listGameApplicationsRequest: ListGameApplicationsRequest,
  ): Promise<TwirpResponse<ListGameApplicationsResponse>> {
    return Promise.resolve(this.listGameApplicationsMock(listGameApplicationsRequest));
  }
  public getGameApplicationsByCompany(id: Id): Promise<TwirpResponse<GetGameApplicationsByCompanyResponse>> {
    return Promise.resolve(this.getGameApplicationsByCompanyMock(id));
  }
  public getGameApplication(id: Id): Promise<TwirpResponse<GameApplication>> {
    return Promise.resolve(this.getGameApplicationMock(id));
  }
  public createGameApplication(
    createGameApplicationRequest: CreateGameApplicationRequest,
  ): Promise<TwirpResponse<GameApplication>> {
    return Promise.resolve(this.createGameApplicationMock(createGameApplicationRequest));
  }
  public createGameApplicationV2(
    createGameApplicationRequestV2: CreateGameApplicationRequestV2,
  ): Promise<TwirpResponse<GameApplication>> {
    return Promise.resolve(this.createGameApplicationV2Mock(createGameApplicationRequestV2));
  }
  public deleteGameApplication(
    deleteGameApplicationRequest: DeleteGameApplicationRequest,
  ): Promise<TwirpResponse<Empty>> {
    return Promise.resolve(this.deleteGameApplicationMock(deleteGameApplicationRequest));
  }
  public onboardGame(onboardGameRequest: OnboardGameRequest): Promise<TwirpResponse<OnboardGameResponse>> {
    return Promise.resolve(this.onboardGameMock(onboardGameRequest));
  }
  public getDeveloperApplications(
    getDeveloperApplicationsRequest: GetDeveloperApplicationsRequest,
  ): Promise<TwirpResponse<GetDeveloperApplicationsResponse>> {
    return Promise.resolve(this.getDeveloperApplicationsMock(getDeveloperApplicationsRequest));
  }
  public deleteDeveloperApplication(
    deleteDeveloperApplicationRequest: DeleteDeveloperApplicationRequest,
  ): Promise<TwirpResponse<Empty>> {
    return Promise.resolve(this.deleteDeveloperApplicationMock(deleteDeveloperApplicationRequest));
  }
  public onboardDeveloper(
    onboardDeveloperRequest: OnboardDeveloperRequest,
  ): Promise<TwirpResponse<OnboardDeveloperResponse>> {
    return Promise.resolve(this.onboardDeveloperMock(onboardDeveloperRequest));
  }
  public getGamesByCompany(id: Id): Promise<TwirpResponse<GetGamesByCompanyResponse>> {
    return Promise.resolve(this.getGamesByCompanyMock(id));
  }
  public getGamesByTwitchID(id: Id): Promise<TwirpResponse<GetGamesByTwitchIDResponse>> {
    return Promise.resolve(this.getGamesByTwitchIDMock(id));
  }
  public getCompanyByTwitchID(id: Id): Promise<TwirpResponse<Company>> {
    return Promise.resolve(this.getCompanyByTwitchIDMock(id));
  }
  public createJWT(jWTRequest: JWTRequest): Promise<TwirpResponse<JWT>> {
    return Promise.resolve(this.createJWTMock(jWTRequest));
  }
  public getAllGamesWithCompanies(
    getAllGamesWithCompaniesRequest: GetAllGamesWithCompaniesRequest,
  ): Promise<TwirpResponse<GetAllGamesWithCompaniesResponse>> {
    return Promise.resolve(this.getAllGamesWithCompaniesMock(getAllGamesWithCompaniesRequest));
  }
  public isFeatureEnabled(
    isFeatureEnabledRequest: IsFeatureEnabledRequest,
  ): Promise<TwirpResponse<FeatureEnabledResponse>> {
    return Promise.resolve(this.isFeatureEnabledMock(isFeatureEnabledRequest));
  }
  public isValueEnabled(isValueEnabledRequest: IsValueEnabledRequest): Promise<TwirpResponse<FeatureEnabledResponse>> {
    return Promise.resolve(this.isValueEnabledMock(isValueEnabledRequest));
  }
}

// tslint:disable-next-line:max-classes-per-file
export class RBACAdminMock implements RBACAdmin {
  public deleteCompanyMock: jest.Mock<TwirpResponse<Empty>>;
  public offboardResourceMock: jest.Mock<TwirpResponse<Empty>>;
  public transferCompanyOwnershipMock: jest.Mock<TwirpResponse<Empty>>;
  public whitelistUserMock: jest.Mock<TwirpResponse<Empty>>;
  public removeUserFromWhitelistMock: jest.Mock<TwirpResponse<Empty>>;
  public updateUserRoleInWhitelistMock: jest.Mock<TwirpResponse<Empty>>;
  public listUserWhitelistByRoleMock: jest.Mock<TwirpResponse<ListUserWhitelistByRoleResponse>>;
  public getFeatureGatingValueInBoolMock: jest.Mock<TwirpResponse<GetFeatureGatingValueResponse>>;
  public setFeatureGatingBoolValueMock: jest.Mock<TwirpResponse<Empty>>;
  public getFeatureGatingValueInStringsMock: jest.Mock<TwirpResponse<GetFeatureGatingValueResponse>>;
  public updateFeatureGatingValueMock: jest.Mock<TwirpResponse<GetFeatureGatingValueResponse>>;
  public createShadowAccountMock: jest.Mock<TwirpResponse<CreateShadowAccountResponse>>;

  public constructor() {
    this.deleteCompanyMock = jest.fn();
    this.offboardResourceMock = jest.fn();
    this.transferCompanyOwnershipMock = jest.fn();
    this.whitelistUserMock = jest.fn();
    this.removeUserFromWhitelistMock = jest.fn();
    this.updateUserRoleInWhitelistMock = jest.fn();
    this.listUserWhitelistByRoleMock = jest.fn();
    this.getFeatureGatingValueInBoolMock = jest.fn();
    this.setFeatureGatingBoolValueMock = jest.fn();
    this.getFeatureGatingValueInStringsMock = jest.fn();
    this.updateFeatureGatingValueMock = jest.fn();
    this.createShadowAccountMock = jest.fn();
  }
  public deleteCompany(deleteCompanyRequest: DeleteCompanyRequest): Promise<TwirpResponse<Empty>> {
    return Promise.resolve(this.deleteCompanyMock(deleteCompanyRequest));
  }
  public offboardResource(offboardResourceRequest: OffboardResourceRequest): Promise<TwirpResponse<Empty>> {
    return Promise.resolve(this.offboardResourceMock(offboardResourceRequest));
  }
  public transferCompanyOwnership(
    transferCompanyOwnershipRequest: TransferCompanyOwnershipRequest,
  ): Promise<TwirpResponse<Empty>> {
    return Promise.resolve(this.transferCompanyOwnershipMock(transferCompanyOwnershipRequest));
  }
  public whitelistUser(whitelistUserRequest: WhitelistUserRequest): Promise<TwirpResponse<Empty>> {
    return Promise.resolve(this.whitelistUserMock(whitelistUserRequest));
  }
  public removeUserFromWhitelist(
    removeUserFromWhitelistRequest: RemoveUserFromWhitelistRequest,
  ): Promise<TwirpResponse<Empty>> {
    return Promise.resolve(this.removeUserFromWhitelistMock(removeUserFromWhitelistRequest));
  }
  public updateUserRoleInWhitelist(whitelistUserRequest: WhitelistUserRequest): Promise<TwirpResponse<Empty>> {
    return Promise.resolve(this.updateUserRoleInWhitelistMock(whitelistUserRequest));
  }
  public listUserWhitelistByRole(
    listUserWhitelistByRoleRequest: ListUserWhitelistByRoleRequest,
  ): Promise<TwirpResponse<ListUserWhitelistByRoleResponse>> {
    return Promise.resolve(this.listUserWhitelistByRoleMock(listUserWhitelistByRoleRequest));
  }
  public getFeatureGatingValueInBool(
    getFeatureGatingValueRequest: GetFeatureGatingValueRequest,
  ): Promise<TwirpResponse<GetFeatureGatingValueResponse>> {
    return Promise.resolve(this.getFeatureGatingValueInBoolMock(getFeatureGatingValueRequest));
  }
  public setFeatureGatingBoolValue(
    setFeatureGatingBoolValueRequest: SetFeatureGatingBoolValueRequest,
  ): Promise<TwirpResponse<Empty>> {
    return Promise.resolve(this.setFeatureGatingBoolValueMock(setFeatureGatingBoolValueRequest));
  }
  public getFeatureGatingValueInStrings(
    getFeatureGatingValueRequest: GetFeatureGatingValueRequest,
  ): Promise<TwirpResponse<GetFeatureGatingValueResponse>> {
    return Promise.resolve(this.getFeatureGatingValueInStringsMock(getFeatureGatingValueRequest));
  }
  public updateFeatureGatingValue(
    updateFeatureGatingValueRequest: UpdateFeatureGatingValueRequest,
  ): Promise<TwirpResponse<GetFeatureGatingValueResponse>> {
    return Promise.resolve(this.updateFeatureGatingValueMock(updateFeatureGatingValueRequest));
  }
  public createShadowAccount(
    createShadowAccountRequest: CreateShadowAccountRequest,
  ): Promise<TwirpResponse<CreateShadowAccountResponse>> {
    return Promise.resolve(this.createShadowAccountMock(createShadowAccountRequest));
  }
}

// tslint:disable-next-line:max-classes-per-file
export class RBACActionHistoryMock implements RBACActionHistory {
  public listEntityActionHistoriesMock: jest.Mock<TwirpResponse<ListActionHistoriesResponse>>;
  public listActionHistoriesMock: jest.Mock<TwirpResponse<ListActionHistoriesResponse>>;

  public constructor() {
    this.listEntityActionHistoriesMock = jest.fn();
    this.listActionHistoriesMock = jest.fn();
  }
  public listEntityActionHistories(
    listEntityActionHistoriesRequest: ListEntityActionHistoriesRequest,
  ): Promise<TwirpResponse<ListActionHistoriesResponse>> {
    return Promise.resolve(this.listEntityActionHistoriesMock(listEntityActionHistoriesRequest));
  }
  public listActionHistories(
    listActionHistoriesRequest: ListActionHistoriesRequest,
  ): Promise<TwirpResponse<ListActionHistoriesResponse>> {
    return Promise.resolve(this.listActionHistoriesMock(listActionHistoriesRequest));
  }
}

// tslint:disable-next-line:max-classes-per-file
export class ExtensionReviewsMock implements ExtensionReviews {
  public setStateInReviewMock: jest.Mock<TwirpResponse<Empty>>;
  public getLatestAuthorNotesMock: jest.Mock<TwirpResponse<GetLatestAuthorNotesResponse>>;
  public getExtensionMock: jest.Mock<TwirpResponse<Extension>>;
  public setStateApprovedMock: jest.Mock<TwirpResponse<Empty>>;
  public setStatePendingActionMock: jest.Mock<TwirpResponse<Empty>>;

  public constructor() {
    this.setStateInReviewMock = jest.fn();
    this.getLatestAuthorNotesMock = jest.fn();
    this.getExtensionMock = jest.fn();
    this.setStateApprovedMock = jest.fn();
    this.setStatePendingActionMock = jest.fn();
  }
  public setStateInReview(setStateInReviewRequest: SetStateInReviewRequest): Promise<TwirpResponse<Empty>> {
    return Promise.resolve(this.setStateInReviewMock(setStateInReviewRequest));
  }
  public getLatestAuthorNotes(
    getLatestAuthorNotesRequest: GetLatestAuthorNotesRequest,
  ): Promise<TwirpResponse<GetLatestAuthorNotesResponse>> {
    return Promise.resolve(this.getLatestAuthorNotesMock(getLatestAuthorNotesRequest));
  }
  public getExtension(extensionVersionID: ExtensionVersionID): Promise<TwirpResponse<Extension>> {
    return Promise.resolve(this.getExtensionMock(extensionVersionID));
  }
  public setStateApproved(setStateReviewerRequest: SetStateReviewerRequest): Promise<TwirpResponse<Empty>> {
    return Promise.resolve(this.setStateApprovedMock(setStateReviewerRequest));
  }
  public setStatePendingAction(setStateReviewerRequest: SetStateReviewerRequest): Promise<TwirpResponse<Empty>> {
    return Promise.resolve(this.setStatePendingActionMock(setStateReviewerRequest));
  }
}
